/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataHandler;
import org.gcube.datatransformation.datatransformationlibrary.model.ExtTransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.model.HandlerDesc;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.Source;
import org.gcube.datatransformation.datatransformationlibrary.model.Target;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationProgram;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransformationUnit {
    private String id = null;
    private boolean isComposite = false;
    private ArrayList<Source> sources = new ArrayList();
    private Target target = null;
    private ArrayList<ExtTransformationUnit> extTransformationList = null;
    private TransformationProgram transformationProgram;
    private ArrayList<Parameter> programParameters = new ArrayList();
    private ArrayList<HandlerDesc> ios = new ArrayList();
    private HashSet<String> handledIOIDs = new HashSet();
    private HashMap<String, DataHandler> handlers = new HashMap();

    public ArrayList<Parameter> getProgramParameters() {
        return this.programParameters;
    }

    public void setProgramParameters(ArrayList<Parameter> programParameters) {
        this.programParameters = programParameters;
    }

    public void fromDOM(Element transformation) {
        Element targetElm;
        Element sourceElm;
        this.setId(transformation.getAttribute("id"));
        if (transformation.getAttribute("isComposite") != null && transformation.getAttribute("isComposite").equals("true")) {
            this.isComposite = true;
        }
        int cnt = 0;
        while ((sourceElm = (Element)transformation.getElementsByTagName("Source").item(cnt++)) != null) {
            Source source = new Source();
            source.fromDOM(sourceElm);
            source.setTransformationUnit(this);
            this.sources.add(source);
            HandlerDesc desc = new HandlerDesc(source.getInputID(), HandlerDesc.HandlerType.Input, source);
            this.ios.add(desc);
            this.handledIOIDs.add(source.getInputID());
        }
        Element programParameters = (Element)transformation.getElementsByTagName("ProgramParameters").item(0);
        if (programParameters != null) {
            Element parameter;
            int cnt2 = 0;
            while ((parameter = (Element)programParameters.getElementsByTagName("Parameter").item(cnt2++)) != null) {
                Parameter param = new Parameter();
                param.setName(parameter.getAttribute("name"));
                param.setValue(parameter.getAttribute("value"));
                this.programParameters.add(param);
            }
        }
        if ((targetElm = (Element)transformation.getElementsByTagName("Target").item(0)) != null) {
            this.target = new Target();
            this.target.fromDOM(targetElm);
            this.target.setTransformationUnit(this);
            HandlerDesc desc = new HandlerDesc(this.target.getOutputID(), HandlerDesc.HandlerType.Output, this.target);
            this.ios.add(desc);
            this.handledIOIDs.add(this.target.getOutputID());
        }
        if (this.isComposite) {
            Element exttransformation;
            this.extTransformationList = new ArrayList();
            cnt = 0;
            while ((exttransformation = (Element)transformation.getElementsByTagName("ExtTransformationUnit").item(cnt++)) != null) {
                ExtTransformationUnit exttransformationinst = new ExtTransformationUnit();
                exttransformationinst.setTransformationUnit(this);
                exttransformationinst.fromDOM(exttransformation);
                this.extTransformationList.add(exttransformationinst);
            }
        }
    }

    public void toDOM(Element tp) {
        Document doc = tp.getOwnerDocument();
        Element transformationUnit = doc.createElement("TransformationUnit");
        Attr id = doc.createAttribute("id");
        id.setTextContent(this.id);
        transformationUnit.setAttributeNode(id);
        Attr iscomp = doc.createAttribute("isComposite");
        iscomp.setTextContent(String.valueOf(this.isComposite));
        transformationUnit.setAttributeNode(iscomp);
        Element sourcesElm = doc.createElement("Sources");
        for (Source source : this.sources) {
            source.toDOM(sourcesElm);
        }
        transformationUnit.appendChild(sourcesElm);
        Element programParametersElm = doc.createElement("ProgramParameters");
        if (this.programParameters != null && this.programParameters.size() > 0) {
            for (Parameter param : this.programParameters) {
                param.toDOM(programParametersElm);
            }
        }
        transformationUnit.appendChild(programParametersElm);
        this.target.toDOM(transformationUnit);
        if (this.isComposite) {
            Element composition = doc.createElement("Composition");
            for (ExtTransformationUnit exttr : this.extTransformationList) {
                exttr.toDOM(composition);
            }
            transformationUnit.appendChild(composition);
        }
        tp.appendChild(transformationUnit);
    }

    public ArrayList<ExtTransformationUnit> getExtTransformationList() {
        return this.extTransformationList;
    }

    public void setExtTransformationList(ArrayList<ExtTransformationUnit> extTransformationList) {
        this.extTransformationList = extTransformationList;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isComposite() {
        return this.isComposite;
    }

    public void setComposite(boolean isComposite) {
        this.isComposite = isComposite;
    }

    public ArrayList<Source> getSources() {
        return this.sources;
    }

    public void setSources(ArrayList<Source> sources) {
        if (sources != null && sources.size() > 0) {
            for (Source source : sources) {
                HandlerDesc desc = new HandlerDesc(source.getInputID(), HandlerDesc.HandlerType.Input, source);
                this.ios.add(desc);
                this.handledIOIDs.add(source.getInputID());
            }
        }
        this.sources = sources;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        if (target != null) {
            HandlerDesc desc = new HandlerDesc(target.getOutputID(), HandlerDesc.HandlerType.Output, target);
            this.ios.add(desc);
            this.handledIOIDs.add(target.getOutputID());
        }
        this.target = target;
    }

    public TransformationProgram getTransformationProgram() {
        return this.transformationProgram;
    }

    public void setTransformationProgram(TransformationProgram transformationProgram) {
        this.transformationProgram = transformationProgram;
    }

    public ArrayList<HandlerDesc> getIOs() {
        return this.ios;
    }

    public void addBridge(String id) {
        HandlerDesc desc = new HandlerDesc(id, HandlerDesc.HandlerType.Bridge, null);
        this.ios.add(desc);
        this.handledIOIDs.add(id);
    }

    public boolean containsHandler(String id) {
        return this.handledIOIDs.contains(id);
    }

    public void bindHandler(String id, DataHandler handler) throws Exception {
        if (!this.handledIOIDs.contains(id)) {
            throw new Exception("Transformation does not contain handler with id " + id);
        }
        this.handlers.put(id, handler);
    }

    public DataHandler getDataHandler(String id) throws Exception {
        if (!this.handledIOIDs.contains(id)) {
            throw new Exception("Transformation does not contain handler with id " + id);
        }
        DataHandler handler = this.handlers.get(id);
        if (handler == null) {
            throw new Exception("Handler with id " + id + " is not bound to any DataHandler Object");
        }
        return handler;
    }

    public List<Parameter> mergeProgramParameters() {
        ArrayList<Parameter> globalProgramParameters = this.transformationProgram.getTransformer().getGlobalProgramParams();
        ArrayList<Parameter> finalProgramParameters = new ArrayList<Parameter>();
        if (globalProgramParameters != null && globalProgramParameters.size() > 0) {
            for (Parameter globalProgramParameter : globalProgramParameters) {
                finalProgramParameters.add(globalProgramParameter);
            }
        }
        if (this.programParameters != null && this.programParameters.size() > 0) {
            for (Parameter tUnitProgramParameter : this.programParameters) {
                for (Parameter globalProgramParameter : finalProgramParameters) {
                    if (!globalProgramParameter.getName().equalsIgnoreCase(tUnitProgramParameter.getName())) continue;
                    finalProgramParameters.remove(globalProgramParameter);
                    break;
                }
                finalProgramParameters.add(tUnitProgramParameter);
            }
        }
        return finalProgramParameters;
    }
}

