/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement;

import java.io.File;
import org.gcube.datatransformation.datatransformationlibrary.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollector
extends Thread {
    private File tmpDirectory;
    private static Logger log = LoggerFactory.getLogger(GarbageCollector.class);
    private static long filelifetime = PropertiesManager.getInMillisPropertyValue("gcollector.filelifetime", "1800");
    private static long reGCollectInterval = PropertiesManager.getInMillisPropertyValue("gcollector.gcollectinterval", "600");

    public GarbageCollector(File tmpDirectory) {
        this.tmpDirectory = tmpDirectory;
        this.setDaemon(true);
        this.setPriority(1);
        log.info("Garbage collector created to collect from: " + tmpDirectory.getAbsolutePath());
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    log.trace("Garbage collector sleeping for " + reGCollectInterval / 1000L + " secs");
                    Thread.sleep(reGCollectInterval);
                    log.trace("Garbage collector starts checking for files to delete in " + this.tmpDirectory.getAbsolutePath());
                    this.collect();
                }
            }
            catch (Exception e) {
                log.error("Exception at garbage collecting ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected void forceTempFilesDeletion() {
        File[] subdirectories = this.tmpDirectory.listFiles();
        if (subdirectories == null) {
            log.warn("Temporary directory does not exist");
            return;
        }
        if (subdirectories.length == 0) {
            log.trace("Temporary directory does not contain any files or subdirectories");
            return;
        }
        for (File subdir : subdirectories) {
            try {
                if (subdir.isDirectory()) {
                    File[] sudirfiles;
                    for (File file : sudirfiles = subdir.listFiles()) {
                        if (file.delete()) {
                            log.trace("File " + file.getAbsolutePath() + " deleted successfully");
                            continue;
                        }
                        log.error("File " + file.getAbsolutePath() + " could not be deleted");
                    }
                }
                if (subdir.delete()) {
                    log.trace("File " + subdir.getAbsolutePath() + " deleted successfully");
                    continue;
                }
                log.error("File " + subdir.getAbsolutePath() + " could not be deleted");
            }
            catch (Exception e) {
                log.error("Unexpected error in trying to delete files in dts temporary directory", (Throwable)e);
            }
        }
    }

    private void collect() {
        File[] subdirectories = this.tmpDirectory.listFiles();
        if (subdirectories == null) {
            log.warn("Temporary directory does not exist");
            return;
        }
        if (subdirectories.length == 0) {
            log.trace("Temporary directory does not contain any files or subdirectories");
            return;
        }
        for (File subdir : subdirectories) {
            try {
                if (subdir.isDirectory()) {
                    File[] sudirfiles;
                    for (File file : sudirfiles = subdir.listFiles()) {
                        if (this.isFileForDeletion(file)) {
                            if (file.delete()) {
                                log.trace("File " + file.getAbsolutePath() + " deleted successfully");
                                continue;
                            }
                            log.error("File " + file.getAbsolutePath() + " could not be deleted");
                            continue;
                        }
                        log.trace("File " + file.getAbsolutePath() + " is not going to be deleted. (yet...)");
                    }
                }
                if (this.isFileForDeletion(subdir)) {
                    if (subdir.delete()) {
                        log.trace("File " + subdir.getAbsolutePath() + " deleted successfully");
                        continue;
                    }
                    log.error("File " + subdir.getAbsolutePath() + " could not be deleted");
                    continue;
                }
                log.trace("File " + subdir.getAbsolutePath() + " is not going to be deleted. (yet...)");
            }
            catch (Exception e) {
                log.error("Unexpected error in trying to delete files in dts temporary directory", (Throwable)e);
            }
        }
    }

    private boolean isFileForDeletion(File file) {
        return file.lastModified() < System.currentTimeMillis() - filelifetime;
    }

    public static void configGCFileLifetime(long filelifetime) {
        GarbageCollector.filelifetime = filelifetime;
    }

    public static void configReGCollectInterval(long reGCollectInterval) {
        GarbageCollector.reGCollectInterval = reGCollectInterval;
    }
}

