/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model;

import java.net.URL;
import java.util.ArrayList;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.SoftwarePackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Transformer {
    private String programClass;
    private ArrayList<Parameter> globalProgramParameters = new ArrayList();
    private ArrayList<SoftwarePackage> softwarePackages = new ArrayList();

    public ArrayList<SoftwarePackage> getSoftwarePackages() {
        return this.softwarePackages;
    }

    public void setSoftwarePackages(ArrayList<SoftwarePackage> softwarePackages) {
        this.softwarePackages = softwarePackages;
    }

    public String getProgramClass() {
        return this.programClass;
    }

    public void setProgramClass(String programClass) {
        this.programClass = programClass;
    }

    public ArrayList<Parameter> getGlobalProgramParams() {
        return this.globalProgramParameters;
    }

    public void setGlobalProgramParams(ArrayList<Parameter> programParams) {
        this.globalProgramParameters = programParams;
    }

    protected void fromDOM(Element transformer) throws Exception {
        Element progclass = (Element)transformer.getElementsByTagName("Class").item(0);
        if (progclass != null && progclass.getTextContent().trim().length() > 0) {
            Element parameter;
            this.setProgramClass(progclass.getTextContent());
            ArrayList<Parameter> programParametersList = new ArrayList<Parameter>();
            int cnt = 0;
            while ((parameter = (Element)transformer.getElementsByTagName("Parameter").item(cnt++)) != null) {
                Parameter param = new Parameter();
                param.setName(parameter.getAttribute("name"));
                param.setValue(parameter.getAttribute("value"));
                programParametersList.add(param);
            }
            this.setGlobalProgramParams(programParametersList);
            this.softwarePackages.clear();
            Element software = (Element)transformer.getElementsByTagName("Software").item(0);
            if (software != null) {
                Element swrpackage;
                int cnt2 = 0;
                while ((swrpackage = (Element)software.getElementsByTagName("Package").item(cnt2++)) != null) {
                    SoftwarePackage pkg = new SoftwarePackage();
                    pkg.setId(swrpackage.getElementsByTagName("PKGID").item(0).getTextContent());
                    pkg.setLocation(new URL(swrpackage.getElementsByTagName("Location").item(0).getTextContent()));
                    this.softwarePackages.add(pkg);
                }
            }
        }
    }

    protected void toDOM(Element tp) {
        Document doc = tp.getOwnerDocument();
        Element transformerelm = doc.createElement("Transformer");
        tp.appendChild(transformerelm);
        Element sftelm = doc.createElement("Software");
        if (this.softwarePackages != null && this.softwarePackages.size() > 0) {
            for (SoftwarePackage pkg : this.softwarePackages) {
                Element pkgelm = doc.createElement("Package");
                Element pkgid = doc.createElement("PKGID");
                pkgid.setTextContent(pkg.getId());
                Element pkgloc = doc.createElement("Location");
                pkgloc.setTextContent(pkg.getLocation().toString());
                pkgelm.appendChild(pkgid);
                pkgelm.appendChild(pkgloc);
                sftelm.appendChild(pkgelm);
            }
        }
        transformerelm.appendChild(sftelm);
        Element cls = doc.createElement("Class");
        cls.setTextContent(this.programClass);
        transformerelm.appendChild(cls);
        Element progparams = doc.createElement("GlobalProgramParameters");
        if (this.globalProgramParameters != null && this.globalProgramParameters.size() > 0) {
            for (Parameter param : this.globalProgramParameters) {
                param.toDOM(progparams);
            }
        }
        transformerelm.appendChild(progparams);
        tp.appendChild(transformerelm);
    }
}

