/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.dataelements.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.activation.URLDataSource;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileDataElement
extends DataElement {
    private static Logger log = LoggerFactory.getLogger(LocalFileDataElement.class);
    private File file;

    public void setContent(File file) {
        this.file = file;
    }

    @Override
    public InputStream getContent() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            log.error("File " + this.file.getAbsolutePath() + " could not be found", (Throwable)e);
            return null;
        }
    }

    public File getFileContent() {
        return this.file;
    }

    @Override
    public ContentType getContentType() {
        if (super.getContentType() == null) {
            try {
                URLDataSource urlDS = new URLDataSource(this.file.toURL());
                ContentType contentFormat = new ContentType();
                String contentTypeEvalueated = urlDS.getContentType();
                log.trace("The content type of " + this.file.toURL() + " is " + contentTypeEvalueated);
                contentFormat.setMimeType(contentTypeEvalueated);
                this.setContentType(contentFormat);
            }
            catch (Exception e) {
                log.error("Did not manage to evaluate content format of file " + this.file);
            }
        }
        return super.getContentType();
    }

    public static LocalFileDataElement getSourceDataElement() {
        return new LocalFileDataElement();
    }

    public static LocalFileDataElement getSinkDataElement(DataElement sourceDataElement) {
        LocalFileDataElement targetDataElement = new LocalFileDataElement();
        for (String attrName : sourceDataElement.getAllAttributes().keySet()) {
            targetDataElement.setAttribute(attrName, sourceDataElement.getAttributeValue(attrName));
        }
        return targetDataElement;
    }

    @Override
    public void destroy() {
        try {
            if (this.file.exists()) {
                this.file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

