/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesManager {
    private static Properties dtsLibProperties = new Properties();
    private static Logger log = LoggerFactory.getLogger(PropertiesManager.class);
    private static final String DTSLIBPROPERTIESFILE = "dtslib.properties";

    public static Properties getDTSLibProperties() {
        return dtsLibProperties;
    }

    public static String getPropertyValue(String propertyName, String defaultValue) {
        return dtsLibProperties.getProperty(propertyName, defaultValue);
    }

    public static long getInMillisPropertyValue(String propertyName, String defaultValue) {
        return Long.parseLong(dtsLibProperties.getProperty(propertyName, defaultValue)) * 1000L;
    }

    public static long getLongPropertyValue(String propertyName, String defaultValue) {
        return Long.parseLong(dtsLibProperties.getProperty(propertyName, defaultValue));
    }

    public static int getIntPropertyValue(String propertyName, String defaultValue) {
        return Integer.parseInt(dtsLibProperties.getProperty(propertyName, defaultValue));
    }

    public static double getDoublePropertyValue(String propertyName, String defaultValue) {
        return Double.parseDouble(dtsLibProperties.getProperty(propertyName, defaultValue));
    }

    public static boolean getBooleanPropertyValue(String propertyName, String defaultValue) {
        return Boolean.parseBoolean(dtsLibProperties.getProperty(propertyName, defaultValue));
    }

    static {
        try {
            dtsLibProperties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(DTSLIBPROPERTIESFILE));
            log.info("Managed to load dts lib properties");
        }
        catch (Exception e) {
            log.error("Did not manage to load dts lib properties", (Throwable)e);
        }
    }
}

