/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.security;

import java.util.HashMap;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSGHNConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSSManager {
    private static InheritableThreadLocal<GCUBEScope> transactionScope = new InheritableThreadLocal();
    private static InheritableThreadLocal<SecurityCredentials> transactionCredentials = new InheritableThreadLocal();
    private static volatile GCUBESecurityManager securityManager = null;
    private static Logger log = LoggerFactory.getLogger(DTSSManager.class);
    protected static volatile HashMap<GCUBEScope, DTSCore> dCoreMap = new HashMap();

    public static void setSecurityManager(GCUBESecurityManager manager) {
        securityManager = manager;
    }

    public static GCUBESecurityManager getSecurityManager() {
        try {
            securityManager.useCredentials((SecurityCredentials)transactionCredentials.get());
        }
        catch (Exception e) {
            log.error("Cannot use credentials in the current thread", (Throwable)e);
        }
        return securityManager;
    }

    public static void useCredentials(SecurityCredentials credentials) {
        transactionCredentials.set(credentials);
    }

    public static GCUBEScope getScope() {
        return (GCUBEScope)transactionScope.get();
    }

    public static void setScope(GCUBEScope scope) {
        transactionScope.set(scope);
    }

    public static DTSCore getDTSCore() throws GCUBEFault {
        if (DTSSManager.getScope() == null) {
            log.error("Scope not specified");
            throw new GCUBEUnrecoverableException("Scope not specified").toFault(new String[0]);
        }
        DTSCore dCore = dCoreMap.get(DTSSManager.getScope());
        if (dCore == null) {
            log.error("DTS is not deployed in scope " + DTSSManager.getScope());
            throw new GCUBEUnrecoverableException("DTS is not deployed in scope " + DTSSManager.getScope()).toFault(new String[0]);
        }
        return dCore;
    }

    public static void init(GCUBEServiceContext serviceContext) throws Exception {
        log.debug("DTSSManager is initialized...");
        DTSGHNConsumer consumer = new DTSGHNConsumer();
        serviceContext.getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)consumer, new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE, GCUBEResource.ResourceTopic.REMOVESCOPE});
    }
}

