/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.ProgramExecutor;
import org.gcube.datatransformation.datatransformationlibrary.PropertiesManager;
import org.gcube.datatransformation.datatransformationlibrary.TransformationUnitAndBridge;
import org.gcube.datatransformation.datatransformationlibrary.adaptor.DTSAdaptor;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.ExtTransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.model.HandlerDesc;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.Source;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationProgram;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.model.Transformer;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraph;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.gcube.datatransformation.datatransformationlibrary.transformation.model.TransformationDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSCore {
    private static Logger log = LoggerFactory.getLogger(DTSCore.class);
    private static Metric findTransformationUnitByGraphMetric = StatisticsManager.createMetric("FindTransformationUnitByGraphMetric", "Time to search for transformationUnit Unit by transformations graph", StatisticsManager.MetricType.DTS);
    private IManager iManager;
    private DTSAdaptor adaptor;
    private TransformationsGraph graph;
    private static String DEFAULTFASTBRIDGECLASS = "org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.REFDataBridge";
    private static String DEFAULTADAPTORCLASS = "gr.uoa.di.madgik.workflow.adaptor.datatransformation.WorkflowDTSAdaptor";
    private static String FASTBRIDGECLASS = PropertiesManager.getPropertyValue("dcore.fastbridgeclass", DEFAULTFASTBRIDGECLASS);
    private static String DTSADAPTOR = PropertiesManager.getPropertyValue("dcore.adaptor", DEFAULTADAPTORCLASS);
    private static String DEFAULTHARDBRIDGECLASS = "org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.RSBlobDataBridge";
    private static String HARDBRIDGECLASS = PropertiesManager.getPropertyValue("dcore.hardbridgeclass", DEFAULTHARDBRIDGECLASS);

    public IManager getIManager() {
        return this.iManager;
    }

    public DTSCore(IManager iManager, TransformationsGraph graph) throws Exception {
        if (iManager == null || graph == null) {
            log.error("Information Manager or Transformations Graph is not set...");
            throw new Exception("Information Manager or Transformations Graph is not set...");
        }
        this.iManager = iManager;
        this.graph = graph;
    }

    public void destroy() {
        this.graph.destroy();
        this.iManager = null;
    }

    private void transformDataWithProgram(ArrayList<DataSource> sources, Transformer transformer, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        ProgramExecutor.transformDataWithProgram(sources, transformer, programParameters, targetContentType, sink);
    }

    private void transformDataWithAdaptor(ArrayList<TransformationUnit> transformationUnits, ArrayList<ContentType> mimeTypes) throws Exception {
        this.adaptor.addPlan(transformationUnits, mimeTypes);
    }

    public void initializeAdaptor(TransformationDescription desc) throws Exception {
        try {
            this.adaptor = (DTSAdaptor)Class.forName(DTSADAPTOR).newInstance();
        }
        catch (Exception e) {
            log.error("Could not create data transformation adaptor", (Throwable)e);
            return;
        }
        this.adaptor.setTransPlan(desc);
        this.adaptor.SetScope(DTSSManager.getScope().toString());
        this.adaptor.CreatePlan();
        String output = this.adaptor.ExecutePlan();
        desc.setReturnedValue(output);
    }

    private void transformDataWithTransformationUnit(TransformationUnit transformationUnit, ContentType targetContentType) throws Exception {
        ArrayList<TransformationUnit> tPath = new ArrayList<TransformationUnit>();
        ArrayList<ContentType> targetContentTypes = new ArrayList<ContentType>();
        if (transformationUnit != null) {
            if (transformationUnit.isComposite()) {
                log.info("Composite transformationUnit to be performed...");
                int extTransformationsSize = transformationUnit.getExtTransformationList().size();
                block0: for (int i = 0; i < extTransformationsSize; ++i) {
                    ExtTransformationUnit exttransformation = transformationUnit.getExtTransformationList().get(i);
                    TransformationProgram extTP = this.iManager.getTransformationProgram(exttransformation.getReferencedTransformationProgramID());
                    for (TransformationUnit extTPTransformation : extTP.getTransformationUnits()) {
                        if (!extTPTransformation.getId().equals(exttransformation.getReferencedTransformationUnitID())) continue;
                        if (transformationUnit.getProgramParameters() != null && transformationUnit.getProgramParameters().size() > 0) {
                            this.setProgramParametersOfTransformationUnit(extTPTransformation, transformationUnit.getProgramParameters().toArray(new Parameter[transformationUnit.getProgramParameters().size()]));
                        }
                        ContentType finalContentType = DTSCore.mergeContentTypeParametersToApply(targetContentType, extTPTransformation.getTarget().getContentType());
                        log.debug("Invoking (external) " + extTPTransformation.getTransformationProgram().getId() + "/" + extTPTransformation.getId() + " with target content type " + finalContentType.toString());
                        tPath.add(extTPTransformation);
                        targetContentTypes.add(finalContentType);
                        continue block0;
                    }
                }
            } else {
                tPath.add(transformationUnit);
                targetContentTypes.add(targetContentType);
            }
        } else {
            targetContentTypes.add(targetContentType);
        }
        this.transformDataWithAdaptor(tPath, targetContentTypes);
    }

    private static List<Parameter> mergeProgramParameters(ArrayList<Parameter> globalProgramParameters, ArrayList<Parameter> tUnitProgramParameters) {
        ArrayList<Parameter> finalProgramParameters = new ArrayList<Parameter>();
        if (globalProgramParameters != null && globalProgramParameters.size() > 0) {
            for (Parameter globalProgramParameter : globalProgramParameters) {
                finalProgramParameters.add(globalProgramParameter);
            }
        }
        if (tUnitProgramParameters != null && tUnitProgramParameters.size() > 0) {
            for (Parameter tUnitProgramParameter : tUnitProgramParameters) {
                for (Parameter globalProgramParameter : finalProgramParameters) {
                    if (!globalProgramParameter.getName().equalsIgnoreCase(tUnitProgramParameter.getName())) continue;
                    finalProgramParameters.remove(globalProgramParameter);
                    break;
                }
                finalProgramParameters.add(tUnitProgramParameter);
            }
        }
        return finalProgramParameters;
    }

    private static ContentType mergeContentTypeParametersToApply(ContentType targetContentType, ContentType transformationsContentType) throws Exception {
        if (transformationsContentType == null) {
            log.error("Transformations Content Type does not exist");
            throw new Exception("Transformations Content Type does not exist");
        }
        if (targetContentType == null) {
            log.warn("Target Content Type does not exist");
            return transformationsContentType.clone();
        }
        if (transformationsContentType.getContentTypeParameters() == null || transformationsContentType.getContentTypeParameters().size() == 0 || targetContentType == null || targetContentType.getContentTypeParameters().size() == 0) {
            ContentType finalFormat = transformationsContentType.clone();
            Iterator<Parameter> it = finalFormat.getContentTypeParameters().iterator();
            while (it.hasNext()) {
                Parameter par = it.next();
                if (!par.getValue().equals("*") && !par.getValue().equals("-")) continue;
                it.remove();
            }
            return finalFormat;
        }
        ContentType finalFormat = new ContentType();
        finalFormat.setMimeType(transformationsContentType.getMimeType());
        ArrayList<Parameter> finalParameters = new ArrayList<Parameter>();
        for (Parameter transformationParam : transformationsContentType.getContentTypeParameters()) {
            Parameter finalParam = new Parameter();
            finalParam.setName(transformationParam.getName());
            String value = transformationParam.getValue();
            if (transformationParam.getValue().equals("*") || transformationParam.getValue().equals("-")) {
                for (Parameter targetParam : targetContentType.getContentTypeParameters()) {
                    if (!targetParam.getName().toLowerCase().equals(transformationParam.getName().toLowerCase())) continue;
                    value = targetParam.getValue();
                    log.trace("Putting in as value of target content type parameter " + transformationParam.getName() + " the " + value);
                }
            }
            finalParam.setValue(value);
            finalParameters.add(finalParam);
        }
        finalFormat.setContentTypeParameters(finalParameters);
        return finalFormat;
    }

    private void setProgramParametersOfTransformationUnit(TransformationUnit transformationUnit, Parameter[] programUnboundParameters) {
        ArrayList<Parameter> tuProgParams = transformationUnit.getProgramParameters();
        if (tuProgParams != null && tuProgParams.size() > 0) {
            for (Parameter param : tuProgParams) {
                for (Parameter unboundparam : programUnboundParameters) {
                    if (param.getName() == null || unboundparam.getName() == null || !param.getName().equalsIgnoreCase(unboundparam.getName())) continue;
                    log.trace("Setting value " + unboundparam.getName() + "=\"" + unboundparam.getValue() + "\" in tu " + transformationUnit.getId());
                    param.setValue(unboundparam.getValue());
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transformDataWithTransformationProgram(DataSource source, TransformationProgram transformationProgram, ContentType targetContentType) throws Exception {
        HashMap<Integer, TransformationUnitAndBridge> contentTypeToTransformationUnit = new HashMap<Integer, TransformationUnitAndBridge>();
        try {
            while (source.hasNext()) {
                try {
                    ContentType contentType = source.nextContentType();
                    if (contentType == null) continue;
                    TransformationUnitAndBridge trandbridges = (TransformationUnitAndBridge)contentTypeToTransformationUnit.get(contentType.hashCode());
                    ContentType finalTargetContentType = targetContentType;
                    if (trandbridges == null) {
                        for (TransformationUnit tmptr : transformationProgram.getTransformationUnits()) {
                            if (tmptr.getSources().size() != 1) {
                                log.error("Invocation transformDataWithKnownTP in TPs with more that one Sources is not permitted...");
                                continue;
                            }
                            if (!tmptr.getSources().get(0).getContentType().getMimeType().equalsIgnoreCase(contentType.getMimeType()) || !tmptr.getTarget().getContentType().getMimeType().equalsIgnoreCase(targetContentType.getMimeType()) || !Parameter.equals(tmptr.getSources().get(0).getContentType().getContentTypeParameters(), contentType.getContentTypeParameters()) || !Parameter.equals(tmptr.getTarget().getContentType().getContentTypeParameters(), targetContentType.getContentTypeParameters())) continue;
                            trandbridges = new TransformationUnitAndBridge();
                            trandbridges.transformationUnit = tmptr;
                            break;
                        }
                        if (trandbridges == null) {
                            for (TransformationUnit tmptr : transformationProgram.getTransformationUnits()) {
                                if (tmptr.getSources().size() != 1) {
                                    log.error("Invocation transformDataWithKnownTP in TPs with more that one Sources is not permitted...");
                                    continue;
                                }
                                if (!ContentType.support(tmptr.getSources().get(0).getContentType(), contentType) || !ContentType.support(tmptr.getTarget().getContentType(), targetContentType)) continue;
                                trandbridges = new TransformationUnitAndBridge();
                                trandbridges.transformationUnit = tmptr;
                                break;
                            }
                        }
                        if (trandbridges == null) {
                            log.info("Trying generic support...");
                            for (TransformationUnit tmptr : transformationProgram.getTransformationUnits()) {
                                if (tmptr.getSources().size() != 1) {
                                    log.error("Invocation transformDataWithKnownTP in TPs with more that one Sources is not permitted...");
                                    continue;
                                }
                                if (!ContentType.gensupport(tmptr.getSources().get(0).getContentType(), contentType) || !ContentType.gensupport(tmptr.getTarget().getContentType(), targetContentType)) continue;
                                finalTargetContentType = tmptr.getTarget().getContentType();
                                trandbridges = new TransformationUnitAndBridge();
                                trandbridges.transformationUnit = tmptr;
                                break;
                            }
                        }
                        if (trandbridges == null) {
                            log.warn("Could not find transformationUnit in the TP: " + transformationProgram.getId() + " for object with content type " + contentType.toString());
                            continue;
                        }
                        contentTypeToTransformationUnit.put(contentType.hashCode(), trandbridges);
                        this.transformDataWithTransformationUnit(trandbridges.transformationUnit, finalTargetContentType);
                    }
                    if (!trandbridges.srcbridge.isClosed()) continue;
                    log.warn("Bridge of " + trandbridges.transformationUnit.getTransformationProgram().getId() + "/" + trandbridges.transformationUnit.getId() + " is closed, cannot append data element");
                }
                catch (Exception e) {
                    log.error("Undefined error inside the iteration of the source objects.", (Throwable)e);
                }
            }
            try {
                source.close();
            }
            catch (Exception e) {
                log.error("Did not manage to close initial data source", (Throwable)e);
            }
            this.adaptor.finishedAddingPLans();
            for (TransformationUnitAndBridge trandbridge : contentTypeToTransformationUnit.values()) {
                if (trandbridge.srcbridge == null) continue;
                trandbridge.srcbridge.close();
            }
            return;
        }
        catch (Exception e) {
            log.error("Undefined error in DTSCore ", (Throwable)e);
            throw new Exception("Undefined error in DTSCore", e);
        }
    }

    private static void closeSourcesAndSinkOfTransformationUnit(TransformationUnit transformationUnit) {
        try {
            ArrayList<Source> sources = transformationUnit.getSources();
            if (sources != null) {
                for (Source source : sources) {
                    try {
                        source.getInput().close();
                    }
                    catch (Exception e1) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void transformDataWithTransformationProgram(DataSource source, String transformationProgramID, Parameter[] programUnboundParameters, ContentType targetContentType) throws Exception {
        ArrayList<Parameter> tpProgParams;
        TransformationProgram transformationProgram;
        try {
            transformationProgram = this.iManager.getTransformationProgram(transformationProgramID);
        }
        catch (Exception e) {
            log.error("Could not perform the transformationUnit as dCore could not find program with id: " + transformationProgramID);
            throw new Exception("Could not perform the transformationUnit as dCore could not find program with id: " + transformationProgramID);
        }
        if (programUnboundParameters != null && programUnboundParameters.length > 0 && (tpProgParams = transformationProgram.getTransformer().getGlobalProgramParams()) != null && tpProgParams.size() > 0) {
            for (Parameter param : tpProgParams) {
                for (Parameter unboundparam : programUnboundParameters) {
                    if (param.getName() == null || unboundparam.getName() == null || !param.getName().equalsIgnoreCase(unboundparam.getName())) continue;
                    param.setValue(unboundparam.getValue());
                }
            }
        }
        this.transformDataWithTransformationProgram(source, transformationProgram, targetContentType);
    }

    public void transformDataWithTransformationUnit(String transformationProgramID, String transformationUnitID, Parameter[] programUnboundParameters, ContentType targetContentType, boolean filterSources) throws Exception {
        TransformationUnit transformationUnit;
        try {
            transformationUnit = this.iManager.getTransformationUnit(transformationProgramID, transformationUnitID);
        }
        catch (Exception e) {
            log.error("Did not manage to get transformationUnit Unit with id " + transformationProgramID + "/" + transformationUnitID + " from iManager", (Throwable)e);
            throw new Exception("Did not manage to get transformationUnit Unit with id " + transformationProgramID + "/" + transformationUnitID + " from iManager", e);
        }
        if (programUnboundParameters != null && programUnboundParameters.length > 0) {
            this.setProgramParametersOfTransformationUnit(transformationUnit, programUnboundParameters);
            ArrayList<Parameter> tpProgParams = transformationUnit.getTransformationProgram().getTransformer().getGlobalProgramParams();
            if (tpProgParams != null && tpProgParams.size() > 0) {
                for (Parameter param : tpProgParams) {
                    for (Parameter unboundparam : programUnboundParameters) {
                        if (param.getName() == null || unboundparam.getName() == null || !param.getName().equalsIgnoreCase(unboundparam.getName())) continue;
                        param.setValue(unboundparam.getValue());
                    }
                }
            }
        }
        ArrayList<HandlerDesc> ios = transformationUnit.getIOs();
        for (HandlerDesc hdesc : ios) {
            if (hdesc.getType().equals((Object)HandlerDesc.HandlerType.Input)) {
                if (!filterSources) continue;
                log.debug("Filtering is enabled...");
                transformationUnit.getSources().get(Integer.parseInt(hdesc.getID().replaceAll("TRInput", ""))).setContentType(hdesc.getRuleElement().getContentType());
                continue;
            }
            if (hdesc.getType().equals((Object)HandlerDesc.HandlerType.Output)) continue;
            if (hdesc.getType().equals((Object)HandlerDesc.HandlerType.Bridge)) {
                transformationUnit.bindHandler(hdesc.getID(), DTSCore.getDataBridge());
                continue;
            }
            log.error("Unknown HandlerDesc type: " + (Object)((Object)hdesc.getType()));
            throw new Exception("Unknown HandlerDesc type: " + (Object)((Object)hdesc.getType()));
        }
        try {
            this.transformDataWithTransformationUnit(transformationUnit, targetContentType);
            this.adaptor.finishedAddingPLans();
        }
        catch (Exception e) {
            DTSCore.closeSourcesAndSinkOfTransformationUnit(transformationUnit);
            throw e;
        }
    }

    public void transformData(final DataSource source, final ContentType targetContentType) {
        Thread dataElementsBroker = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                HashMap<Integer, TransformationUnitAndBridge> contentTypeToTransformationUnit = new HashMap<Integer, TransformationUnitAndBridge>();
                HashSet<Integer> contentTypesWithNoApplicableTUnit = new HashSet<Integer>();
                try {
                    while (source.hasNext()) {
                        ContentType contentType = null;
                        try {
                            contentType = source.nextContentType();
                            if (contentType == null) {
                                log.error("The content type of an object is not evaluated by the data source");
                                continue;
                            }
                            TransformationUnitAndBridge trandbridges = (TransformationUnitAndBridge)contentTypeToTransformationUnit.get(contentType.hashCode());
                            if (trandbridges == null) {
                                if (contentTypesWithNoApplicableTUnit.contains(contentType.hashCode())) {
                                    log.debug("Content type " + contentType + " is already checked and no transformationUnit Unit is available");
                                    log.warn("Could not find transformationUnit for object with type " + contentType.toString() + " and target content type " + targetContentType.toString());
                                    continue;
                                }
                                long starttime = System.currentTimeMillis();
                                ArrayList<TransformationUnit> applicableTransformationUnits = DTSCore.this.graph.findApplicableTransformationUnits(contentType, targetContentType, true);
                                findTransformationUnitByGraphMetric.addMeasure(System.currentTimeMillis() - starttime);
                                if (applicableTransformationUnits != null && applicableTransformationUnits.size() > 0) {
                                    log.info("Managed to find a proper transformationUnit from the graph for the object...");
                                    trandbridges = new TransformationUnitAndBridge();
                                    trandbridges.transformationUnit = applicableTransformationUnits.get(0);
                                    contentTypeToTransformationUnit.put(contentType.hashCode(), trandbridges);
                                    DTSCore.this.transformDataWithTransformationUnit(trandbridges.transformationUnit, targetContentType);
                                    continue;
                                }
                                if (contentType.equals(targetContentType)) {
                                    log.info("No need to transform object. It will be forwarded to output.");
                                    trandbridges = new TransformationUnitAndBridge();
                                    trandbridges.transformationUnit = null;
                                    contentTypeToTransformationUnit.put(contentType.hashCode(), trandbridges);
                                    DTSCore.this.transformDataWithTransformationUnit(trandbridges.transformationUnit, targetContentType);
                                    continue;
                                }
                                log.warn("Could not find transformationUnit for object with type " + contentType.toString() + " and target content type " + targetContentType.toString());
                                contentTypesWithNoApplicableTUnit.add(contentType.hashCode());
                                continue;
                            }
                            log.info("Managed to find the proper transformationUnit in the hashmap for the object...");
                        }
                        catch (Exception e) {
                            log.error("Undefined error inside the iteration of the source objects.", (Throwable)e);
                            if (contentType != null) continue;
                        }
                    }
                    try {
                        source.close();
                    }
                    catch (Exception e) {
                        log.error("Did not manage to close initial data source", (Throwable)e);
                    }
                    DTSCore.this.adaptor.finishedAddingPLans();
                    for (TransformationUnitAndBridge trandbridge : contentTypeToTransformationUnit.values()) {
                        if (trandbridge.srcbridge == null) continue;
                        trandbridge.srcbridge.close();
                    }
                    return;
                }
                catch (Exception e) {
                    log.error("Unknown error in DTSCore ", (Throwable)e);
                }
            }
        };
        dataElementsBroker.start();
    }

    public static DataBridge getDataBridge() {
        try {
            return (DataBridge)Class.forName(FASTBRIDGECLASS).newInstance();
        }
        catch (Exception e) {
            log.error("Could not create data bridge", (Throwable)e);
            return null;
        }
    }

    public static DataBridge getHardDataBridge() {
        try {
            return (DataBridge)Class.forName(HARDBRIDGECLASS).newInstance();
        }
        catch (Exception e) {
            log.error("Could not create data bridge", (Throwable)e);
            return null;
        }
    }

    public ArrayList<TransformationUnit> findApplicableTransformationUnits(ContentType sourceContentType, ContentType targetContentType, boolean createAndPublishCompositeTP) {
        long starttime = System.currentTimeMillis();
        ArrayList<TransformationUnit> availabletransformationUnits = this.graph.findApplicableTransformationUnits(sourceContentType, targetContentType, createAndPublishCompositeTP);
        findTransformationUnitByGraphMetric.addMeasure(System.currentTimeMillis() - starttime);
        return availabletransformationUnits;
    }

    public ArrayList<ContentType> getAvailableTargetContentTypes(ContentType sourceContentType) {
        return this.graph.findAvailableTargetContentTypes(sourceContentType);
    }
}

