/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.reports;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportManager {
    private static HashMap<String, Report> reports = new HashMap();
    private static Logger log = LoggerFactory.getLogger(ReportManager.class);
    private static InheritableThreadLocal<String> reportID = new InheritableThreadLocal();
    private static InheritableThreadLocal<Boolean> reportEnabled = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    protected static String getReportID() {
        log.trace("Returning report ID " + (String)reportID.get());
        return (String)reportID.get();
    }

    public static boolean isReportingEnabled() {
        return (Boolean)reportEnabled.get();
    }

    public static void initializeReport(boolean create) throws Exception {
        if (create) {
            ReportManager.createReport();
        } else {
            reportID.set(null);
            reportEnabled.set(false);
        }
    }

    protected static Report createReport() throws Exception {
        String newReportID;
        Report report = null;
        try {
            report = new Report();
        }
        catch (Exception e) {
            log.error("Could not create report", (Throwable)e);
            reportID.set(null);
            reportEnabled.set(false);
            throw new Exception("Could not create report");
        }
        report.reportID = newReportID = UUID.randomUUID().toString();
        reportID.set(newReportID);
        reportEnabled.set(true);
        reports.put((String)reportID.get(), report);
        return report;
    }

    public static Report getReport() throws Exception {
        Report report = reports.get(reportID.get());
        if (report == null) {
            throw new Exception("Report for transaction " + (String)reportID.get() + " does not exist");
        }
        return report;
    }

    public static void closeReport() {
        if (ReportManager.isReportingEnabled()) {
            try {
                Report report = ReportManager.getReport();
                log.debug("Closing report with id " + report.reportID);
                Set<Map.Entry<String, Record>> uncommitedRecords = report.records.entrySet();
                if (!uncommitedRecords.isEmpty()) {
                    log.warn("There are uncommited records in the report");
                    for (Map.Entry<String, Record> entry : uncommitedRecords) {
                        Record rec = entry.getValue();
                        log.warn("ObjectID " + entry.getKey());
                        log.warn("Payload " + rec.toString());
                    }
                    report.records.clear();
                }
                report.close();
                reports.remove(reportID.get());
            }
            catch (Exception e) {
                log.error("Could not close repornt ", (Throwable)e);
            }
        }
    }

    public static void manageRecord(String objectID, String msg, Record.Status status, Record.Type type) {
        try {
            if (ReportManager.isReportingEnabled()) {
                Record rec = ReportManager.getReport().getRecord(objectID);
                rec.setRecord(msg, status, type);
            }
        }
        catch (Exception e) {
            log.error("Reporting failed ", (Throwable)e);
        }
    }
}

