/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.reports;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.HashMap;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Report {
    protected HashMap<String, Record> records = new HashMap();
    private RecordWriter<GenericRecord> writer = null;
    private static Logger log = LoggerFactory.getLogger(Report.class);
    protected String reportID;

    public Report() throws Exception {
        try {
            RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition("objectID"), new StringFieldDefinition("reportID"), new StringFieldDefinition("report")})};
            this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), defs, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        }
        catch (Exception e) {
            log.error("Could not create RSXMLWriter", (Throwable)e);
            throw new Exception("Could not create RSXMLWriter");
        }
    }

    public String getReportEndpoint() throws Exception {
        try {
            throw new Exception("Not implemented yet.");
        }
        catch (Exception e) {
            log.error("Could not create RSLocator of the report result set", (Throwable)e);
            throw new Exception("Could not create RSLocator of the report result set");
        }
    }

    private Record createRecord(String objectID) {
        Record record = new Record();
        record.report = this;
        record.objectID = objectID;
        this.records.put(objectID, record);
        return record;
    }

    public Record getRecord(String objectID) {
        Record rec = this.records.get(objectID);
        if (rec == null) {
            rec = this.createRecord(objectID);
        }
        return rec;
    }

    protected void commitRecord(Record record) {
        String payload = record.toString();
        try {
            GenericRecord rec = new GenericRecord();
            rec.setFields(new Field[]{new StringField(record.objectID), new StringField(ReportManager.getReportID()), new StringField(payload)});
            this.writer.put((gr.uoa.di.madgik.grs.record.Record)rec);
            this.records.remove(record.objectID);
        }
        catch (Exception e) {
            log.error("Could not add record into result set", (Throwable)e);
        }
    }

    protected void close() {
        try {
            this.records = null;
            this.writer.close();
            this.writer = null;
        }
        catch (Exception e) {
            log.error("Could not close RSXMLWriter", (Throwable)e);
        }
    }
}

