/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentType {
    private String mimeType;
    private List<Parameter> contentTypeParameters = new ArrayList<Parameter>();
    private static Logger log = LoggerFactory.getLogger(ContentType.class);

    public ContentType() {
    }

    public ContentType(String mimeType, List<Parameter> contentTypeParameters) {
        this.mimeType = mimeType;
        this.contentTypeParameters = contentTypeParameters;
    }

    public List<Parameter> getContentTypeParameters() {
        return this.contentTypeParameters;
    }

    public void setContentTypeParameters(List<Parameter> contentTypeParameters) {
        this.contentTypeParameters = contentTypeParameters;
    }

    public void addContentTypeParameters(Parameter ... contentTypeParameters) {
        if (this.contentTypeParameters == null) {
            this.contentTypeParameters = new ArrayList<Parameter>();
        }
        if (contentTypeParameters == null) {
            return;
        }
        for (Parameter param : contentTypeParameters) {
            this.contentTypeParameters.add(param);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void fromDOM(Element contentTypeElement) {
        Element mtelm = (Element)contentTypeElement.getElementsByTagName("Mimetype").item(0);
        this.mimeType = mtelm.getTextContent();
        Element formatparameters = (Element)contentTypeElement.getElementsByTagName("Parameters").item(0);
        if (formatparameters != null) {
            Element parameter;
            ArrayList<Parameter> formatParametersList = new ArrayList<Parameter>();
            int cnt = 0;
            while ((parameter = (Element)formatparameters.getElementsByTagName("Parameter").item(cnt++)) != null) {
                Parameter param = new Parameter();
                param.setName(parameter.getAttribute("name"));
                param.setValue(parameter.getAttribute("value"));
                String isOptional = parameter.getAttribute("isOptional");
                if (isOptional == null || isOptional.equalsIgnoreCase("true")) {
                    param.setOptional(true);
                }
                formatParametersList.add(param);
            }
            this.contentTypeParameters = formatParametersList;
        }
    }

    protected void fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            ByteArrayInputStream instream = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document contentFormatDoc = builder.parse(instream);
            instream.close();
            this.fromDOM(contentFormatDoc.getDocumentElement());
        }
        catch (Exception e) {
            log.error("Could not parse the Content Format: " + xml, (Throwable)e);
            throw new Exception("Could not parse the content format: " + xml);
        }
    }

    public void toDOM(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element contentFormatElm = doc.createElement("ContentType");
        Element mimetype = doc.createElement("Mimetype");
        mimetype.setTextContent(this.mimeType);
        contentFormatElm.appendChild(mimetype);
        Element fmtparams = doc.createElement("Parameters");
        if (this.contentTypeParameters != null && this.contentTypeParameters.size() > 0) {
            for (Parameter fparam : this.contentTypeParameters) {
                fparam.toDOM(fmtparams);
            }
        }
        contentFormatElm.appendChild(fmtparams);
        parent.appendChild(contentFormatElm);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (!Parameter.equals(this.contentTypeParameters, other.contentTypeParameters)) {
            return false;
        }
        if (this.mimeType == null) {
            if (other.mimeType != null) {
                return false;
            }
        } else if (!this.mimeType.equalsIgnoreCase(other.mimeType)) {
            if (this.mimeType.equalsIgnoreCase("text/xml") && other.mimeType.equalsIgnoreCase("application/xml")) {
                return true;
            }
            return this.mimeType.equalsIgnoreCase("application/xml") && other.mimeType.equalsIgnoreCase("text/xml");
        }
        return true;
    }

    public static boolean support(List<Parameter> supported, List<Parameter> ifsupported) {
        ArrayList<Parameter> ifsupportedlist = new ArrayList<Parameter>();
        for (Parameter param : ifsupported) {
            ifsupportedlist.add(param);
        }
        ArrayList<Parameter> supportedlist = new ArrayList<Parameter>();
        for (Parameter param : supported) {
            supportedlist.add(param);
        }
        block2: while (!ifsupportedlist.isEmpty()) {
            Parameter param;
            param = (Parameter)ifsupportedlist.get(0);
            for (Parameter supparam : supportedlist) {
                if (!param.getName().equalsIgnoreCase(supparam.getName())) continue;
                if (!(param.getValue().equalsIgnoreCase(supparam.getValue()) || supparam.getValue().equals("*") || supparam.isOptional())) {
                    return false;
                }
                ifsupportedlist.remove(param);
                supportedlist.remove(supparam);
                continue block2;
            }
            return false;
        }
        for (Parameter param : supportedlist) {
            if (param.isOptional()) continue;
            return false;
        }
        return true;
    }

    public static boolean support(ContentType supported, ContentType ifsupported) {
        if (!supported.getMimeType().equalsIgnoreCase(ifsupported.getMimeType())) {
            return false;
        }
        return ContentType.support(supported.getContentTypeParameters(), ifsupported.getContentTypeParameters());
    }

    public static boolean gensupport(List<Parameter> supported, List<Parameter> ifsupported) {
        if (supported == null && ifsupported == null) {
            return true;
        }
        if (supported == null && ifsupported.size() == 0) {
            return true;
        }
        if (ifsupported == null && supported.size() == 0) {
            return true;
        }
        if (supported.size() == 0 && ifsupported.size() == 0) {
            return true;
        }
        for (Parameter param : ifsupported) {
            for (Parameter supparam : supported) {
                if (!param.getName().equalsIgnoreCase(supparam.getName()) || param.getValue().equalsIgnoreCase(supparam.getValue()) || supparam.getValue().equals("*") || supparam.getValue().equals("-") || supparam.isOptional()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean gensupport(ContentType supported, ContentType ifsupported) {
        if (!supported.getMimeType().equalsIgnoreCase(ifsupported.getMimeType())) {
            return false;
        }
        return ContentType.gensupport(supported.getContentTypeParameters(), ifsupported.getContentTypeParameters());
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.append("MimeType=\"" + this.mimeType + "\"");
        if (this.contentTypeParameters != null && this.contentTypeParameters.size() > 0) {
            for (Parameter param : this.contentTypeParameters) {
                writer.append(", " + param.toString());
            }
        }
        return writer.toString();
    }

    public static List<Parameter> supportAndFillUnbound(List<Parameter> supported, List<Parameter> ifsupported) {
        ArrayList<Parameter> unbound = new ArrayList<Parameter>();
        ArrayList<Parameter> ifsupportedlist = new ArrayList<Parameter>();
        for (Parameter param : ifsupported) {
            ifsupportedlist.add(param);
        }
        ArrayList<Parameter> supportedlist = new ArrayList<Parameter>();
        for (Parameter param : supported) {
            supportedlist.add(param);
        }
        block2: while (!ifsupportedlist.isEmpty()) {
            Parameter param;
            param = (Parameter)ifsupportedlist.get(0);
            for (Parameter supparam : supportedlist) {
                if (!param.getName().equalsIgnoreCase(supparam.getName())) continue;
                if (!(param.getValue().equalsIgnoreCase(supparam.getValue()) || supparam.getValue().equals("*") || supparam.isOptional())) {
                    return null;
                }
                if (supparam.getValue().equals("*") && !param.getValue().equals("*")) {
                    unbound.add(new Parameter(param.getName(), param.getValue()));
                }
                ifsupportedlist.remove(param);
                supportedlist.remove(supparam);
                continue block2;
            }
            return null;
        }
        for (Parameter param : supportedlist) {
            if (param.isOptional()) continue;
            return null;
        }
        return unbound;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Parameter.hashCode(this.contentTypeParameters);
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.toLowerCase().hashCode());
        return result;
    }

    public ContentType clone() {
        ContentType format = new ContentType();
        format.setMimeType(this.mimeType);
        if (this.contentTypeParameters != null) {
            ArrayList<Parameter> newparams = new ArrayList<Parameter>();
            for (Parameter param : this.contentTypeParameters) {
                Parameter newparam = new Parameter();
                newparam.setName(param.getName());
                newparam.setValue(param.getValue());
                if (param.isOptional()) {
                    newparam.setOptional(true);
                }
                newparams.add(newparam);
            }
            format.setContentTypeParameters(newparams);
        }
        return format;
    }
}

