/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils;

import com.google.gson.Gson;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class JSONConverter {
    private static final Gson gson = new Gson();
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});

    public static String toJSON(Object obj) {
        return JSONConverter.toJSON(obj, false);
    }

    public static String toJSON(Object obj, boolean prettyPrint) {
        String json = null;
        if (prettyPrint) {
            try {
                json = mapper.writeValueAsString(obj);
            }
            catch (JsonGenerationException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            json = gson.toJson(obj);
        }
        return json;
    }

    public static String toJSON(String key, String value) {
        return "{\"" + key + "\" : \"" + value + "\"}";
    }
}

