/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.reports;

import java.util.HashMap;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Report {
    protected HashMap<String, Record> records = new HashMap();
    private RSXMLWriter writer;
    private static Logger log = LoggerFactory.getLogger(Report.class);
    protected String reportID;

    public Report() throws Exception {
        try {
            this.writer = RSXMLWriter.getRSXMLWriter();
            this.writer.setRecsPerPart(1);
            this.writer.setTimer(120000L, 180000L, 10000);
        }
        catch (Exception e) {
            log.error("Could not create RSXMLWriter", (Throwable)e);
            throw new Exception("Could not create RSXMLWriter");
        }
    }

    public String getReportEndpoint() throws Exception {
        try {
            throw new Exception("Not implemented yet.");
        }
        catch (Exception e) {
            log.error("Could not create RSLocator of the report result set", (Throwable)e);
            throw new Exception("Could not create RSLocator of the report result set");
        }
    }

    private Record createRecord(String objectID) {
        Record record = new Record();
        record.report = this;
        record.objectID = objectID;
        this.records.put(objectID, record);
        return record;
    }

    public Record getRecord(String objectID) {
        Record rec = this.records.get(objectID);
        if (rec == null) {
            rec = this.createRecord(objectID);
        }
        return rec;
    }

    protected void commitRecord(Record record) {
        String payload = record.toString();
        try {
            ResultElementGeneric rselement = new ResultElementGeneric(record.objectID, ReportManager.getReportID(), "1.0", payload);
            this.writer.addResults((ResultElementBase)rselement);
            this.records.remove(record.objectID);
        }
        catch (Exception e) {
            log.error("Could not add record into result set", (Throwable)e);
        }
    }

    protected void close() {
        try {
            this.records = null;
            this.writer.close();
            this.writer = null;
        }
        catch (Exception e) {
            log.error("Could not close RSXMLWriter", (Throwable)e);
        }
    }
}

