/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model.graph;

import org.gcube.datatransformation.datatransformationlibrary.PropertiesManager;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraphImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Updater
extends Thread {
    private TransformationsGraphImpl graph;
    private boolean finished = false;
    private static Logger log = LoggerFactory.getLogger(Updater.class);
    private static long UPDATEINTERVAL = PropertiesManager.getInMillisPropertyValue("graph.update", "3600");

    public Updater() {
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Transformations Graph Updater");
        while (!this.finished) {
            log.info("Starting updating the Transformations Graph");
            try {
                this.graph.update();
            }
            catch (Exception e1) {
                log.error("Could not update graph keeping the old nodes...", (Throwable)e1);
            }
            log.info("Updating the Transformations Graph has been finished, sleeping for " + UPDATEINTERVAL / 1000L + " secs...");
            try {
                Thread.sleep(UPDATEINTERVAL);
            }
            catch (InterruptedException e) {
                log.info("Updater has been Interupted");
            }
        }
        log.info("Updater has finished...");
    }

    public void setTransformationsGraph(TransformationsGraphImpl graph) {
        this.graph = graph;
    }

    protected void stopThread() {
        this.finished = true;
    }
}

