/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary;

import java.util.ArrayList;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.deployer.DTSProgramDeployer;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.Transformer;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramExecutor {
    private static Logger log = LoggerFactory.getLogger(ProgramExecutor.class);
    private static DTSProgramDeployer deployer;

    public static void initializeDeployer(String DTS_LIBS_PATH) throws Exception {
        deployer = new DTSProgramDeployer(DTS_LIBS_PATH);
    }

    public static void transformDataWithProgram(final ArrayList<DataSource> sources, final Transformer transformer, final List<Parameter> programParameters, final ContentType targetContentType, final DataSink sink) throws Exception {
        if (transformer == null || transformer.getProgramClass() == null || transformer.getProgramClass().trim().length() == 0) {
            log.error("Transformer not specified");
            throw new Exception("Transformer not specified");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (deployer == null) {
            log.warn("DTS Program deployer is not configured. Continuing without using it...");
        } else {
            if (transformer.getSoftwarePackages() != null && transformer.getSoftwarePackages().size() > 0) {
                deployer.deployPackages(transformer.getSoftwarePackages());
            } else {
                log.trace("Transformer does not contain any packages");
            }
            cl = deployer.getClassLoader();
        }
        try {
            log.info("Going to use the program " + transformer.getProgramClass() + "...");
            final Program program = (Program)Class.forName(transformer.getProgramClass(), true, cl).newInstance();
            Thread transformerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread.currentThread().setName("Program Executor");
                    try {
                        log.debug("Program starts transforming data...");
                        program.transform(sources, programParameters, targetContentType, sink);
                        log.debug("Program finished transforming data...");
                    }
                    catch (Throwable err) {
                        log.error("Uncaught error in program " + transformer.getProgramClass(), err);
                    }
                    finally {
                        log.debug("Closing the sink and sources just in case...");
                        try {
                            if (sink != null) {
                                sink.close();
                            }
                            for (DataSource source : sources) {
                                try {
                                    source.close();
                                }
                                catch (Exception e1) {}
                            }
                        }
                        catch (Exception e1) {}
                    }
                }
            };
            transformerThread.setContextClassLoader(cl);
            transformerThread.start();
            return;
        }
        catch (Throwable err) {
            log.error("Could not invoke " + transformer.getProgramClass(), err);
            throw new Exception("Could not invoke " + transformer.getProgramClass(), err);
        }
    }
}

