/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model;

import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.SoftwarePackage;
import org.gcube.datatransformation.datatransformationlibrary.model.Target;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.model.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransformationProgram {
    private String id = null;
    private String name = null;
    private String description = null;
    private Transformer transformer = null;
    private ArrayList<TransformationUnit> transformationUnits = null;
    private static Logger log = LoggerFactory.getLogger(TransformationProgram.class);

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<TransformationUnit> getTransformationUnits() {
        return this.transformationUnits;
    }

    public void setTransformationUnits(ArrayList<TransformationUnit> transformationUnits) {
        this.transformationUnits = transformationUnits;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public static void main(String[] args) throws Exception {
        TransformationProgram tp = new TransformationProgram();
        Transformer transformer = new Transformer();
        SoftwarePackage sft = new SoftwarePackage();
        sft.setId("fdsfds");
        sft.setLocation(new URL("http://lala.org"));
        ArrayList<SoftwarePackage> softwarePackages = new ArrayList<SoftwarePackage>();
        softwarePackages.add(sft);
        transformer.setSoftwarePackages(softwarePackages);
        tp.setTransformer(transformer);
        TransformationUnit transformationUnit = new TransformationUnit();
        transformationUnit.setId("0");
        Target trg = new Target();
        trg.setContentType(new ContentType());
        transformationUnit.setTarget(trg);
        ArrayList<TransformationUnit> tUnits = new ArrayList<TransformationUnit>();
        tUnits.add(transformationUnit);
        tp.setTransformationUnits(tUnits);
        System.out.println(tp.toXML());
    }

    public void fromDOM(Element tpresource) throws Exception {
        Element transformation;
        Element transformer;
        Element desc;
        Element name;
        Element id = (Element)tpresource.getElementsByTagName("ID").item(0);
        if (id != null) {
            this.setId(id.getTextContent());
        }
        if ((name = (Element)tpresource.getElementsByTagName("Name").item(0)) != null) {
            this.setName(name.getTextContent());
        }
        if ((desc = (Element)tpresource.getElementsByTagName("Description").item(0)) != null) {
            this.setDescription(desc.getTextContent());
        }
        if ((transformer = (Element)tpresource.getElementsByTagName("Transformer").item(0)) != null) {
            this.transformer = new Transformer();
            this.transformer.fromDOM(transformer);
        }
        ArrayList<TransformationUnit> tUnitslist = new ArrayList<TransformationUnit>();
        int cnt = 0;
        while ((transformation = (Element)tpresource.getElementsByTagName("TransformationUnit").item(cnt++)) != null) {
            TransformationUnit transformationUnitInst = new TransformationUnit();
            transformationUnitInst.setTransformationProgram(this);
            transformationUnitInst.fromDOM(transformation);
            tUnitslist.add(transformationUnitInst);
        }
        this.setTransformationUnits(tUnitslist);
    }

    public void toDom(Element tpresource) throws Exception {
        Document doc = tpresource.getOwnerDocument();
        Element resource = doc.createElement("gDTSTransformationProgram");
        Element ID = doc.createElement("ID");
        ID.setTextContent(this.id);
        resource.appendChild(ID);
        Element type = doc.createElement("Type");
        resource.appendChild(type);
        Element profile = doc.createElement("Profile");
        resource.appendChild(profile);
        Element secType = doc.createElement("SecondaryType");
        secType.setTextContent("DTSTransformationProgram");
        profile.appendChild(secType);
        Element name = doc.createElement("Name");
        name.setTextContent(this.name);
        profile.appendChild(name);
        Element desciption = doc.createElement("Description");
        desciption.setTextContent(this.description);
        profile.appendChild(desciption);
        Element body = doc.createElement("Body");
        profile.appendChild(body);
        Element tp = doc.createElement("gDTSTransformationProgram");
        body.appendChild(tp);
        if (this.transformer != null) {
            this.transformer.toDOM(tp);
        } else {
            Element transformerelm = doc.createElement("Transformer");
            tp.appendChild(transformerelm);
        }
        if (this.transformationUnits == null || this.transformationUnits.size() < 1) {
            throw new Exception("Transformation program must contain at least one transformationUnit");
        }
        Element transformations = doc.createElement("TransformationUnits");
        for (TransformationUnit tr : this.getTransformationUnits()) {
            tr.toDOM(transformations);
        }
        tp.appendChild(transformations);
        tpresource.appendChild(resource);
    }

    public String toXML() throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element resource = doc.createElement("Resource");
            doc.appendChild(resource);
            Element ID = doc.createElement("ID");
            ID.setTextContent(this.id);
            resource.appendChild(ID);
            Element type = doc.createElement("Type");
            resource.appendChild(type);
            Element profile = doc.createElement("Profile");
            resource.appendChild(profile);
            Element secType = doc.createElement("SecondaryType");
            secType.setTextContent("DTSTransformationProgram");
            profile.appendChild(secType);
            Element name = doc.createElement("Name");
            name.setTextContent(this.name);
            profile.appendChild(name);
            Element desciption = doc.createElement("Description");
            desciption.setTextContent(this.description);
            profile.appendChild(desciption);
            Element body = doc.createElement("Body");
            profile.appendChild(body);
            Element tp = doc.createElement("gDTSTransformationProgram");
            body.appendChild(tp);
            if (this.transformer != null) {
                this.transformer.toDOM(tp);
            } else {
                Element transformerelm = doc.createElement("Transformer");
                tp.appendChild(transformerelm);
            }
            if (this.transformationUnits == null || this.transformationUnits.size() < 1) {
                throw new Exception("Transformation program must contain at least one transformationUnit");
            }
            Element transformations = doc.createElement("TransformationUnits");
            for (TransformationUnit tr : this.getTransformationUnits()) {
                tr.toDOM(transformations);
            }
            tp.appendChild(transformations);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            javax.xml.transform.Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            log.error("Could not serialize Transformation Program", (Throwable)e);
            throw new Exception("Could not serialize Transformation Program");
        }
    }
}

