/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model;

import java.util.ArrayList;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.TargetHandlerDesc;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtTransformationUnit {
    private TransformationUnit transformationUnit;
    private String referencedTransformationProgramID = null;
    private String referencedTransformationUnitID = null;
    private List<Parameter> unboundContentTypeParameters = null;
    private ArrayList<TargetHandlerDesc> targetIOs;

    public TransformationUnit getTransformationUnit() {
        return this.transformationUnit;
    }

    public void setTransformationUnit(TransformationUnit transformationUnit) {
        this.transformationUnit = transformationUnit;
    }

    protected void fromDOM(Element extTransformationElm) {
        TargetHandlerDesc hdesc;
        String htype;
        String hthis;
        String htarget;
        Element handler;
        this.referencedTransformationProgramID = extTransformationElm.getAttribute("tpid");
        this.referencedTransformationUnitID = extTransformationElm.getAttribute("tuid");
        this.targetIOs = new ArrayList();
        int cnt = 0;
        while ((handler = (Element)extTransformationElm.getElementsByTagName("TargetInput").item(cnt++)) != null) {
            htarget = handler.getAttribute("targetID");
            hthis = handler.getAttribute("thisID");
            htype = "TargetInput";
            hdesc = new TargetHandlerDesc(htarget, hthis, htype);
            this.targetIOs.add(hdesc);
            if (!hthis.startsWith("TRBridge") || this.transformationUnit.containsHandler(hthis)) continue;
            this.transformationUnit.addBridge(hthis);
        }
        cnt = 0;
        while ((handler = (Element)extTransformationElm.getElementsByTagName("TargetOutput").item(cnt++)) != null) {
            htarget = handler.getAttribute("targetID");
            hthis = handler.getAttribute("thisID");
            htype = "TargetOutput";
            hdesc = new TargetHandlerDesc(htarget, hthis, htype);
            this.targetIOs.add(hdesc);
            if (!hthis.startsWith("TRBridge") || this.transformationUnit.containsHandler(hthis)) continue;
            this.transformationUnit.addBridge(hthis);
        }
        Element unboundparamselm = (Element)extTransformationElm.getElementsByTagName("UnboundParameters").item(0);
        if (unboundparamselm != null) {
            Element parameter;
            ArrayList<Parameter> unboundParametersList = new ArrayList<Parameter>();
            cnt = 0;
            while ((parameter = (Element)unboundparamselm.getElementsByTagName("Parameter").item(cnt++)) != null) {
                Parameter param = new Parameter();
                param.setName(parameter.getAttribute("name"));
                param.setValue(parameter.getAttribute("value"));
                unboundParametersList.add(param);
            }
            this.unboundContentTypeParameters = unboundParametersList;
        }
    }

    protected void toDOM(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element exttransformationElm = doc.createElement("ExtTransformationUnit");
        Attr tpid = doc.createAttribute("tpid");
        tpid.setTextContent(this.referencedTransformationProgramID);
        exttransformationElm.setAttributeNode(tpid);
        Attr transformationid = doc.createAttribute("tuid");
        transformationid.setTextContent(this.referencedTransformationUnitID);
        exttransformationElm.setAttributeNode(transformationid);
        for (TargetHandlerDesc thdesc : this.targetIOs) {
            Element datahandlerElm = doc.createElement(thdesc.getType());
            Attr iotarget = doc.createAttribute("targetID");
            iotarget.setTextContent(thdesc.getTargetID());
            Attr iothis = doc.createAttribute("thisID");
            iothis.setTextContent(thdesc.getThisID());
            datahandlerElm.setAttributeNode(iotarget);
            datahandlerElm.setAttributeNode(iothis);
            exttransformationElm.appendChild(datahandlerElm);
        }
        Element unboundparams = doc.createElement("UnboundParameters");
        if (this.unboundContentTypeParameters != null && this.unboundContentTypeParameters.size() > 0) {
            for (Parameter unparam : this.unboundContentTypeParameters) {
                unparam.toDOM(unboundparams);
            }
        }
        exttransformationElm.appendChild(unboundparams);
        parent.appendChild(exttransformationElm);
    }

    public String getReferencedTransformationProgramID() {
        return this.referencedTransformationProgramID;
    }

    public void setReferencedTransformationProgramID(String referencedTransformationProgramID) {
        this.referencedTransformationProgramID = referencedTransformationProgramID;
    }

    public String getReferencedTransformationUnitID() {
        return this.referencedTransformationUnitID;
    }

    public void setReferencedTransformationUnitID(String referencedTransformationID) {
        this.referencedTransformationUnitID = referencedTransformationID;
    }

    public List<Parameter> getUnboundContentTypeParameters() {
        return this.unboundContentTypeParameters;
    }

    public void setUnboundContentTypeParameters(List<Parameter> unboundparams) {
        this.unboundContentTypeParameters = unboundparams;
    }

    public ArrayList<TargetHandlerDesc> getTargetIOs() {
        return this.targetIOs;
    }

    public void setTargetIOs(ArrayList<TargetHandlerDesc> targetIOs) {
        for (TargetHandlerDesc desc : targetIOs) {
            if (!desc.getThisID().startsWith("TRBridge") || this.transformationUnit.containsHandler(desc.getThisID())) continue;
            this.transformationUnit.addBridge(desc.getThisID());
        }
        this.targetIOs = targetIOs;
    }
}

