/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs;

import java.io.File;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.LocalFileDataElement;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Elm2ElmProgram;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.gcube.datatransformation.datatransformationlibrary.utils.FilesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class File2FileProgram
extends Elm2ElmProgram {
    private static Logger log = LoggerFactory.getLogger(File2FileProgram.class);
    private String subdir = null;

    @Override
    public DataElement transformDataElement(DataElement sourceDataElement, List<Parameter> programParameters, ContentType targetContentType) throws Exception {
        File transformedFile;
        File sourceFile;
        if (this.subdir == null) {
            this.subdir = TempFileManager.genarateTempSubDir();
        }
        File sudDir = new File(this.subdir);
        sudDir.deleteOnExit();
        if (sourceDataElement instanceof LocalFileDataElement) {
            sourceFile = ((LocalFileDataElement)sourceDataElement).getFileContent();
        } else {
            String inputfile = TempFileManager.generateTempFileName(this.subdir);
            try {
                FilesUtils.streamToFile(sourceDataElement.getContent(), inputfile);
            }
            catch (Exception e) {
                log.error("Could not persist input to file", (Throwable)e);
                throw new Exception("Could not persist input to file", e);
            }
            sourceFile = new File(inputfile);
        }
        try {
            String targetContentPath = TempFileManager.generateTempFileName(this.subdir);
            transformedFile = this.transformFile(sourceFile, programParameters, targetContentType, targetContentPath);
        }
        catch (Exception e) {
            log.error("Did not manage to transform file", (Throwable)e);
            throw new Exception("Did not manage to transform file", e);
        }
        LocalFileDataElement transformedObject = LocalFileDataElement.getSinkDataElement(sourceDataElement);
        transformedObject.setId(sourceDataElement.getId());
        transformedObject.setContentType(targetContentType);
        transformedObject.setContent(transformedFile);
        return transformedObject;
    }

    public abstract File transformFile(File var1, List<Parameter> var2, ContentType var3, String var4) throws Exception;
}

