/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.imanagers;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPEnvelope;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationProgram;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class RemoteIManager
implements IManager {
    private String remoteIManagerEndpoint;
    private Call call;

    public RemoteIManager(String remoteIManagerEndpoint) throws Exception {
        this.remoteIManagerEndpoint = remoteIManagerEndpoint;
        Service service = new Service();
        this.call = (Call)service.createCall();
        this.call.setTargetEndpointAddress(remoteIManagerEndpoint);
    }

    @Override
    public String[] getAvailableTransformationProgramIDs() throws Exception {
        return null;
    }

    @Override
    public TransformationProgram getTransformationProgram(String transformationProgramID) throws Exception {
        System.out.println("Getting transformationUnit program " + transformationProgramID + " from " + this.remoteIManagerEndpoint);
        try {
            Message trsmsg = new Message((Object)("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><queryTransformationPrograms xmlns=\"http://gcube-system.org/namespaces/datatransformation/DataTransformationService\">GET DESCRIPTION WHERE TRANSFORMATIONPROGRAMID=" + transformationProgramID + "</queryTransformationPrograms>" + "</soapenv:Body>" + "</soapenv:Envelope>"));
            SOAPEnvelope response = this.call.invoke(trsmsg);
            String transformationXML = response.getAsDOM().getElementsByTagName("queryTransformationProgramsResponse").item(0).getTextContent();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(transformationXML);
            InputSource inputSource = new InputSource(reader);
            Document transformationDoc = builder.parse(inputSource);
            TransformationProgram tp = new TransformationProgram();
            tp.fromDOM(transformationDoc.getDocumentElement());
            return tp;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            throw new Exception("Did not manage to find any transformationUnit", e);
        }
    }

    @Override
    public TransformationUnit getTransformationUnit(String transformationProgramID, String transformationUnitID) throws Exception {
        TransformationProgram transformationProgram = this.getTransformationProgram(transformationProgramID);
        if (transformationProgram.getTransformationUnits() == null || transformationProgram.getTransformationUnits().size() == 0) {
            System.err.println("Transformation program with id " + transformationProgramID + " does not contain any transformations");
            throw new Exception("Transformation program with id " + transformationProgramID + " does not contain any transformations");
        }
        for (TransformationUnit transformationUnit : transformationProgram.getTransformationUnits()) {
            if (!transformationUnit.getId().equals(transformationUnitID)) continue;
            return transformationUnit;
        }
        System.err.println("Did not manage to find transformationUnit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
        throw new Exception("Did not manage to find transformationUnit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
    }

    @Override
    public void publishTransformationProgram(TransformationProgram transformationProgram) throws Exception {
    }

    @Override
    public String queryTransformationPrograms(String query) throws Exception {
        return null;
    }
}

