/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.imanagers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.ContentTypeQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.DescriptionQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.ProgramParametersQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.QueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.QueryParser;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.TransformationUnitQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationProgram;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ISManager
implements IManager {
    private static Logger log = LoggerFactory.getLogger(ISManager.class);
    private String scope;

    @Override
    public String[] getAvailableTransformationProgramIDs() throws Exception {
        try {
            ScopeProvider.instance.set(this.scope);
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType/string() eq 'DTSTransformationProgram'").setResult("$resource/ID/text()");
            DiscoveryClient client = ICFactory.client();
            List results = client.submit((Query)query);
            if (results.size() == 0) {
                log.warn("Did not manage to find any available transformationUnit programs");
                return new String[0];
            }
            return results.toArray(new String[results.size()]);
        }
        catch (Exception e) {
            log.error("Could not invoke IS to find the available transformationUnit program IDs", (Throwable)e);
            throw new Exception("Could not invoke IS to find the available transformationUnit program IDs");
        }
    }

    @Override
    public TransformationProgram getTransformationProgram(String transformationProgramID) throws Exception {
        GenericResource resource;
        try {
            ScopeProvider.instance.set(this.scope);
            XQuery query = ICFactory.queryFor(GenericResource.class);
            if (transformationProgramID.startsWith("$")) {
                String xsltName = transformationProgramID.substring(1);
                log.debug("Going to get XSLT from IS with name " + xsltName + " from scope " + this.scope.toString());
                query.addCondition("$resource/Profile/Name eq '" + xsltName + "'");
            } else {
                log.debug("Going to get XSLT from IS with ID " + transformationProgramID + " from scope " + this.scope.toString());
                query.addCondition("$resource/ID eq '" + transformationProgramID + "'");
            }
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            List results = client.submit((Query)query);
            if (results == null || results.size() == 0) {
                log.error("Could not find transformationUnit program with id " + transformationProgramID);
                throw new Exception("Could not find transformationUnit program with id " + transformationProgramID);
            }
            resource = (GenericResource)results.get(0);
        }
        catch (Exception e) {
            log.error("Could not invoke IS to find the transformationUnit program with id " + transformationProgramID, (Throwable)e);
            throw new Exception("Could not invoke IS to find the transformationUnit program with id " + transformationProgramID);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            ByteArrayInputStream instream = new ByteArrayInputStream(resource.profile().bodyAsString().getBytes());
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document resourceDoc = builder.parse(instream);
            TransformationProgram programinst = new TransformationProgram();
            programinst.fromDOM(resourceDoc.getDocumentElement());
            programinst.setId(resource.id());
            programinst.setName(resource.profile().name());
            programinst.setDescription(resource.profile().description());
            return programinst;
        }
        catch (Exception e) {
            log.error("Could not parse the resource(Transformation Program)", (Throwable)e);
            throw new Exception("Could not parse the resource(Transformation Program)");
        }
    }

    @Override
    public TransformationUnit getTransformationUnit(String transformationProgramID, String transformationUnitID) throws Exception {
        TransformationProgram transformationProgram = this.getTransformationProgram(transformationProgramID);
        if (transformationProgram.getTransformationUnits() == null || transformationProgram.getTransformationUnits().size() == 0) {
            log.error("Transformation program with id " + transformationProgramID + " does not contain any transformationUnit Units");
            throw new Exception("Transformation program with id " + transformationProgramID + " does not contain any transformationUnit Units");
        }
        for (TransformationUnit transformationUnit : transformationProgram.getTransformationUnits()) {
            if (!transformationUnit.getId().equals(transformationUnitID)) continue;
            return transformationUnit;
        }
        log.error("Did not manage to find transformationUnit Unit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
        throw new Exception("Did not manage to find transformationUnit Unit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
    }

    @Override
    public void publishTransformationProgram(TransformationProgram transformationProgram) throws Exception {
        throw new Exception("Not implemented yet");
    }

    @Override
    public String queryTransformationPrograms(String query) throws Exception {
        QueryObject object = QueryParser.parse(query);
        String result = null;
        if (ContentTypeQueryObject.class.isInstance(object)) {
            log.debug("Quering for Content Types...");
            ContentTypeQueryObject ctobject = (ContentTypeQueryObject)object;
            result = this.queryContentType(ctobject);
        } else if (TransformationUnitQueryObject.class.isInstance(object)) {
            log.debug("Quering for Transformations...");
            TransformationUnitQueryObject tuobject = (TransformationUnitQueryObject)object;
            result = this.queryTransformationUnit(tuobject);
        } else if (DescriptionQueryObject.class.isInstance(object)) {
            log.debug("Quering for Description...");
            DescriptionQueryObject tobject = (DescriptionQueryObject)object;
            result = this.queryDescription(tobject);
        } else if (ProgramParametersQueryObject.class.isInstance(object)) {
            log.debug("Quering for program parameters...");
            ProgramParametersQueryObject ppobject = (ProgramParametersQueryObject)object;
            result = this.queryProgramParameters(ppobject);
        } else {
            log.debug("Invalid query object type");
            throw new Exception("Invalid query object type");
        }
        log.debug("Result of query: " + query + " is \n" + result);
        return result;
    }

    private String queryProgramParameters(ProgramParametersQueryObject object) throws Exception {
        log.debug("Going to get program parameters for " + object.transformationProgramID);
        if (object.transformationProgramID == null || object.transformationProgramID.trim().length() == 0) {
            throw new Exception("Cannot query for description without setting transformationUnit program id");
        }
        TransformationProgram tp = this.getTransformationProgram(object.transformationProgramID);
        StringBuilder result = new StringBuilder();
        result.append("<Result>");
        if (tp.getTransformer().getGlobalProgramParams() != null || tp.getTransformer().getGlobalProgramParams().size() > 0) {
            for (Parameter param : tp.getTransformer().getGlobalProgramParams()) {
                result.append("<Parameter isOptional=\"" + param.isOptional() + "\" name=\"" + param.getName() + "\" value=\"" + param.getValue() + "\"/>");
            }
        }
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            TransformationUnit selected = null;
            for (TransformationUnit tu : tp.getTransformationUnits()) {
                if (!tu.getId().equals(object.transformationUnitID)) continue;
                selected = tu;
                break;
            }
            if (selected == null) {
                throw new Exception("Could not find transformationUnit with id " + object.transformationUnitID + " in TransformationProgram " + object.transformationProgramID);
            }
            for (Parameter param : selected.getProgramParameters()) {
                result.append("<Parameter isOptional=\"" + param.isOptional() + "\" name=\"" + param.getName() + "\" value=\"" + param.getValue() + "\"/>");
            }
        }
        result.append("</Result>");
        return result.toString();
    }

    private String queryDescription(DescriptionQueryObject object) throws Exception {
        log.debug("Going to get description for " + object.transformationProgramID + "/" + object.transformationUnitID);
        if (object.transformationProgramID == null || object.transformationProgramID.trim().length() == 0) {
            throw new Exception("Cannot query for description without setting transformationUnit program id");
        }
        TransformationProgram tp = this.getTransformationProgram(object.transformationProgramID);
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            TransformationUnit selected = null;
            for (TransformationUnit tu : tp.getTransformationUnits()) {
                if (!tu.getId().equals(object.transformationUnitID)) continue;
                selected = tu;
                break;
            }
            if (selected == null) {
                throw new Exception("Could not find transformationUnit with id " + object.transformationUnitID + " in TransformationProgram " + object.transformationProgramID);
            }
            ArrayList<TransformationUnit> tUnits = new ArrayList<TransformationUnit>();
            tUnits.add(selected);
            tp.setTransformationUnits(tUnits);
        }
        return "<Result>" + tp.toXML() + "</Result>";
    }

    private String queryTransformationUnit(TransformationUnitQueryObject object) throws Exception {
        throw new Exception("not implemented yet");
    }

    private String queryContentType(ContentTypeQueryObject object) throws Exception {
        StringBuilder expression = new StringBuilder();
        expression.append("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; ");
        expression.append("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; ");
        expression.append("for $result in collection('/db/Profiles/GenericResource')//Document/Data/is:Profile/Resource ");
        expression.append("where $result/Profile/SecondaryType/string() eq 'DTSTransformationProgram' ");
        if (object.transformationProgramID != null && object.transformationProgramID.trim().length() > 0) {
            expression.append("and $result/ID/string() eq '" + object.transformationProgramID + "'");
        }
        expression.append(" return ");
        expression.append("for $resultin in $result/Profile/Body/gDTSTransformationProgram/TransformationUnits/TransformationUnit");
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            expression.append("[string(@id) eq '" + object.transformationUnitID + "']");
        }
        if (object.getResultType().equals("SCONTENTTYPE")) {
            expression.append("/Sources/Source ");
        } else {
            expression.append("/Target ");
        }
        System.out.println("Mimetype: " + object.contentTypeCondition.getMimetype());
        System.out.println("SubMimetype: " + object.contentTypeCondition.getMimesubtype());
        if (object.contentTypeCondition.getMimetype() == null || object.contentTypeCondition.getMimesubtype() == null) {
            if (object.contentTypeCondition.getMimetype() != null) {
                expression.append("where starts-with($resultin/ContentType/Mimetype/string(), '" + object.contentTypeCondition.getMimetype() + "/') ");
            }
            if (object.contentTypeCondition.getMimesubtype() != null) {
                expression.append("where ends-with($resultin/ContentType/Mimetype/string(), '/" + object.contentTypeCondition.getMimesubtype() + "') ");
            }
        } else {
            expression.append("where $resultin/ContentType/Mimetype/string() eq '" + object.contentTypeCondition.getMimetype() + "/" + object.contentTypeCondition.getMimesubtype() + "' ");
        }
        expression.append("return $resultin/ContentType");
        return this.queryContentFormatByExpression(expression.toString());
    }

    private String queryContentFormatByExpression(String expression) throws Exception {
        throw new Exception("Not implemented yet");
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (scope == null) {
            log.error("Cannot set null scope to the ISManager");
            return;
        }
        log.debug("Setting scope " + scope.toString() + " to ISManager");
        this.scope = scope;
    }
}

