/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.util.LinkedList;
import org.gcube.datatransformation.datatransformationlibrary.PropertiesManager;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REFDataBridge
implements DataBridge {
    private LinkedList<DataElement> objects = new LinkedList();
    private boolean isClosed = false;
    private static boolean flowControled = PropertiesManager.getBooleanPropertyValue("refdatabridge.flowControled", "true");
    private static int limit = PropertiesManager.getIntPropertyValue("refdatabridge.limit", "10");
    private static Logger log = LoggerFactory.getLogger(REFDataBridge.class);

    @Override
    public synchronized void append(DataElement object) {
        if (!this.isClosed) {
            if (flowControled) {
                int minutes = 1;
                while (this.objects.size() >= limit) {
                    try {
                        log.debug("Size of the objects list has reached the limit (" + limit + "), blocking...");
                        this.wait(60000L);
                        if (this.objects.size() < limit) continue;
                        ++minutes;
                        if (this.isClosed) {
                            log.debug("RS buffer was closed");
                            return;
                        }
                        log.debug("RS buffer full.... looping... " + object.getId());
                        if (minutes <= 30) continue;
                        log.warn("Trying several times. Closing writer.");
                        this.close();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            this.objects.add(object);
            if (this.objects.size() == 1) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.notifyAll();
        }
    }

    @Override
    public synchronized boolean hasNext() {
        while (this.objects.size() < 1 && !this.isClosed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.objects.size() != 0 || !this.isClosed;
    }

    @Override
    public synchronized DataElement next() {
        if (!this.hasNext()) {
            return null;
        }
        DataElement elm = this.objects.poll();
        if (flowControled && this.objects.size() == limit - 1) {
            log.debug("Removed an object and the objects size is " + this.objects.size() + ", notifying...");
            this.notifyAll();
        }
        return elm;
    }

    @Override
    public String getOutput() {
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ContentType nextContentType() {
        if (!this.hasNext()) {
            return null;
        }
        DataElement elm = this.objects.poll();
        if (flowControled && this.objects.size() == limit - 1) {
            log.debug("Removed an object and the objects size is " + this.objects.size() + ", notifying...");
            this.notifyAll();
        }
        return elm.getContentType();
    }
}

