/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.ExtTransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.Source;
import org.gcube.datatransformation.datatransformationlibrary.model.Target;
import org.gcube.datatransformation.datatransformationlibrary.model.TargetHandlerDesc;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationProgram;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.model.Transformer;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.NodesCollection;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.Path;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.PathFinder;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TEdge;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TNode;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TNodeWithUnbound;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraph;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.Updater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationsGraphImpl
implements TransformationsGraph {
    private NodesCollection nodes = new NodesCollection();
    private IManager imanager;
    private static Logger log = LoggerFactory.getLogger(TransformationsGraphImpl.class);
    private Updater updater;

    public TransformationsGraphImpl(IManager imanager) {
        Updater updater;
        this.imanager = imanager;
        this.updater = updater = new Updater();
        updater.setTransformationsGraph(this);
        updater.start();
    }

    @Override
    public synchronized void destroy() {
        this.nodes.clear();
        this.updater.stopThread();
        this.updater.interrupt();
    }

    protected synchronized void update() throws Exception {
        String[] programids;
        NodesCollection newNodes = new NodesCollection();
        log.info("Creating Transformations Graph...");
        log.info("Getting available program IDs...");
        try {
            programids = this.imanager.getAvailableTransformationProgramIDs();
        }
        catch (Exception e) {
            log.error("Did not manage to get All Available Transformation Program IDs", (Throwable)e);
            throw new Exception("Did not manage to get All Transformation Available Program IDs");
        }
        if (programids == null || programids.length == 0) {
            log.warn("Could not find any information about transformationUnit programs.");
            return;
        }
        for (String pid : programids) {
            try {
                TransformationProgram transformationProgram;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    log.trace("Going to get transformationUnit program with id " + pid);
                    transformationProgram = this.imanager.getTransformationProgram(pid);
                }
                catch (Exception e) {
                    log.error("Could not get transformationUnit program with id " + pid + ", continuing...", (Throwable)e);
                    continue;
                }
                if (transformationProgram == null) {
                    log.warn("Could not find transformationUnit program with id " + pid + ", continuing...");
                    continue;
                }
                this.addTransformationProgramInGraph(transformationProgram, newNodes);
            }
            catch (Exception e) {
                log.error("Could not add transformationUnit program with id " + pid + " in the graph, continuing...");
            }
        }
        if (this.nodes != null) {
            NodesCollection oldNodes = this.nodes;
            oldNodes.clear();
            Object var3_4 = null;
        }
        this.nodes = newNodes;
    }

    private void addTransformationProgramInGraph(TransformationProgram transformationProgram, NodesCollection newNodes) {
        Transformer transformer = transformationProgram.getTransformer();
        if (transformer != null && transformer.getGlobalProgramParams() != null && transformer.getGlobalProgramParams().size() > 0) {
            for (Parameter progParameter : transformer.getGlobalProgramParams()) {
                if (progParameter == null || progParameter.isOptional() || !progParameter.getValue().equals("-")) continue;
                log.info("Transformation program " + transformationProgram.getId() + " has transformer with compalsory program parameter which is not set. Cannot be part of transformationUnit's graph");
                return;
            }
        }
        ArrayList<TransformationUnit> supportedTransfs = transformationProgram.getTransformationUnits();
        block1: for (TransformationUnit transformationUnit : supportedTransfs) {
            if (transformationUnit.getSources().size() != 1) {
                log.info("Transfomration Units with more than one sources do not take part in transformationUnit's graph, TP: " + transformationProgram.getId() + ", TR: " + transformationUnit.getId());
                continue;
            }
            if (transformationUnit.getProgramParameters() != null && transformationUnit.getProgramParameters().size() > 0) {
                for (Parameter progParameter : transformationUnit.getProgramParameters()) {
                    if (progParameter == null || progParameter.isOptional() || !progParameter.getValue().equals("-")) continue;
                    log.info("Transformation unit " + transformationUnit.getId() + " has compalsory program parameter which is not set. Cannot be part of transformationUnit's graph");
                    continue block1;
                }
            }
            log.debug("Importing in the graph, TP: " + transformationProgram.getId() + ", TU: " + transformationUnit.getId());
            TNode snode = !newNodes.exists(transformationUnit.getSources().get(0).getContentType()) ? newNodes.add(transformationUnit.getSources().get(0).getContentType()) : newNodes.get(transformationUnit.getSources().get(0).getContentType());
            TNode tnode = !newNodes.exists(transformationUnit.getTarget().getContentType()) ? newNodes.add(transformationUnit.getTarget().getContentType()) : newNodes.get(transformationUnit.getTarget().getContentType());
            snode.addEdge(new TEdge(transformationUnit, tnode));
        }
    }

    @Override
    public synchronized ArrayList<TransformationUnit> findApplicableTransformationUnits(ContentType sourceContentType, ContentType targetContentType, boolean createAndPublishCompositeTP) {
        log.info("Trying to find TPs with exact match of the Content Types");
        ArrayList<TransformationUnit> transformationUnits = this.getTransformationUnitsByConsistencyLevel(sourceContentType, targetContentType, Consistency.EXACT, createAndPublishCompositeTP);
        if (transformationUnits != null && transformationUnits.size() > 0) {
            return transformationUnits;
        }
        log.info("Trying to find TPs with supporting match of the Content Types");
        transformationUnits = this.getTransformationUnitsByConsistencyLevel(sourceContentType, targetContentType, Consistency.SUPPORT, createAndPublishCompositeTP);
        if (transformationUnits != null && transformationUnits.size() > 0) {
            return transformationUnits;
        }
        log.info("Trying to find TPs with generic match of the Content Types");
        return this.getTransformationUnitsByConsistencyLevel(sourceContentType, targetContentType, Consistency.GENERIC, createAndPublishCompositeTP);
    }

    @Override
    public synchronized ArrayList<TransformationUnit> findAnyTransformationUnits(ContentType sourceContentType, ContentType targetContentType, boolean createAndPublishCompositeTP) {
        log.info("Trying to find TPs with exact match of the Content Types");
        ArrayList<TransformationUnit> transformationUnits = this.getTransformationUnitsByConsistencyLevel(sourceContentType, targetContentType, Consistency.EXACT, createAndPublishCompositeTP);
        if (transformationUnits != null && transformationUnits.size() > 0) {
            return transformationUnits;
        }
        log.info("Trying to find TPs with supporting match of the Content Types");
        transformationUnits = this.getTransformationUnitsByConsistencyLevel(sourceContentType, targetContentType, Consistency.SUPPORT, createAndPublishCompositeTP);
        if (transformationUnits != null && transformationUnits.size() > 0) {
            return transformationUnits;
        }
        log.info("Trying to find TPs with generic match of the Content Types");
        return this.getTransformationUnitsByConsistencyLevel(sourceContentType, targetContentType, Consistency.GENERIC, createAndPublishCompositeTP);
    }

    @Override
    public synchronized ArrayList<ContentType> findAvailableTargetContentTypes(ContentType sourceContentType) {
        ArrayList<ContentType> targetContentTypes = new ArrayList<ContentType>();
        HashSet<TNode> visited = new HashSet<TNode>();
        LinkedList<TNode> toSearch = new LinkedList<TNode>();
        ArrayList<TNode> snodes = this.nodes.getAnyThatSupport(sourceContentType);
        for (TNode node : snodes) {
            toSearch.add(node);
            visited.add(node);
        }
        while (!toSearch.isEmpty()) {
            TNode tosearch = (TNode)toSearch.poll();
            ArrayList<TEdge> sedges = tosearch.getEdges();
            for (TEdge edge : sedges) {
                TNode tnode = edge.getToNode();
                if (!visited.contains(tnode)) {
                    log.trace("Node: " + tnode.toString() + " not visited");
                    targetContentTypes.add(tnode);
                    toSearch.add(tnode);
                    visited.add(tnode);
                    ArrayList<TNode> nodessuptrg = this.nodes.getAnyThatSupport(tnode);
                    for (TNode nodesuptrg : nodessuptrg) {
                        if (visited.contains(nodesuptrg)) continue;
                        toSearch.add(nodesuptrg);
                        visited.add(nodesuptrg);
                    }
                    continue;
                }
                log.trace("Node: " + tnode.toString() + " already visited");
            }
        }
        return targetContentTypes;
    }

    private ArrayList<TransformationUnit> getTransformationUnitsByConsistencyLevel(ContentType sourceContentType, ContentType targetContentType, Consistency consistencyLevel, boolean createAndPublishCompositeTP) {
        ArrayList<TransformationUnit> transformationUnits = new ArrayList<TransformationUnit>();
        ArrayList<TNodeWithUnbound> snodes = null;
        ArrayList<TNodeWithUnbound> tnodes = null;
        log.info("Trying to find transformationUnit from " + sourceContentType.toString() + " to " + targetContentType.toString() + " with consistency " + (Object)((Object)consistencyLevel) + ".");
        if (sourceContentType.equals(targetContentType)) {
            log.info("Source and target content types are the same, no need to transform the content ;-)...");
            return null;
        }
        if (consistencyLevel.equals((Object)Consistency.EXACT)) {
            snodes = this.nodes.getExactlySupportedWithUnbound(sourceContentType);
            tnodes = this.nodes.getExactlySupportedWithUnbound(targetContentType);
        } else if (consistencyLevel.equals((Object)Consistency.SUPPORT)) {
            snodes = this.nodes.getAnyThatSupportWithUnbound(sourceContentType);
            tnodes = this.nodes.getAnyThatSupportWithUnbound(targetContentType);
        } else if (consistencyLevel.equals((Object)Consistency.GENERIC)) {
            snodes = this.nodes.getGenericallySupported(sourceContentType);
            tnodes = this.nodes.getGenericallySupported(targetContentType);
        } else {
            log.error("...");
            return null;
        }
        if (snodes == null || snodes.isEmpty()) {
            log.trace("DTS doesn't have " + (Object)((Object)consistencyLevel) + " support for any transformation unit for this source.");
            return null;
        }
        if (tnodes == null || tnodes.isEmpty()) {
            log.trace("DTS doesn't have " + (Object)((Object)consistencyLevel) + " support for any transformation unit for this target.");
            return null;
        }
        for (TNodeWithUnbound snode : snodes) {
            ArrayList<TEdge> sedges = snode.getNode().getEdges();
            for (TNodeWithUnbound tnode : tnodes) {
                for (TEdge edge : sedges) {
                    if (!edge.getToNode().equals(tnode.getNode())) continue;
                    transformationUnits.add(edge.getTransformationUnit());
                }
            }
        }
        if (transformationUnits.size() == 0 && createAndPublishCompositeTP) {
            ArrayList<Path> paths = new ArrayList<Path>();
            for (TNodeWithUnbound snode : snodes) {
                Iterator<TNodeWithUnbound> i$ = tnodes.iterator();
                while (i$.hasNext()) {
                    TNodeWithUnbound tnode;
                    PathFinder pfinder = new PathFinder();
                    tnode = i$.next();
                    ArrayList<Path> tmppaths = pfinder.getPaths(snode, tnode, consistencyLevel, this.nodes);
                    if (tmppaths == null || tmppaths.size() <= 0) continue;
                    paths.addAll(tmppaths);
                }
            }
            if (paths != null && paths.size() > 0) {
                Path mincostpath = null;
                log.info("Managed to find " + paths.size() + " paths with " + (Object)((Object)consistencyLevel) + " consistency.");
                for (Path path : paths) {
                    log.trace("PATH: ");
                    for (TEdge edge : path.getPath()) {
                        log.trace("Edge: TP=\"" + edge.getTransformationUnit().getTransformationProgram().getId() + "\" - TR=\"" + edge.getTransformationUnit().getId() + "\"");
                        for (Parameter param : path.getSUnbound(edge)) {
                            log.trace("SrcUnbound: " + param.toString());
                        }
                        for (Parameter param : path.getTUnbound(edge)) {
                            log.trace("TrgUnbound: " + param.toString());
                        }
                    }
                    if (mincostpath != null && !(mincostpath.getCost() > path.getCost())) continue;
                    mincostpath = path;
                }
                if (mincostpath != null) {
                    log.info("The min cost of the path is " + mincostpath.getCost() + ".");
                    TransformationProgram newTP = new TransformationProgram();
                    ContentType tUSourceContentType = mincostpath.getPath().get(0).getTransformationUnit().getSources().get(0).getContentType();
                    ContentType tUTargetContentType = mincostpath.getPath().get(mincostpath.getPath().size() - 1).getTransformationUnit().getTarget().getContentType();
                    newTP.setId(UUID.randomUUID().toString());
                    newTP.setName("TP_" + sourceContentType.getMimeType().replaceAll("/", "_") + "to" + targetContentType.getMimeType().replaceAll("/", "_"));
                    newTP.setDescription("Composite TP automatically created transforming " + tUSourceContentType.toString() + " to " + tUTargetContentType.toString());
                    TransformationUnit transformationUnit = new TransformationUnit();
                    transformationUnit.setTransformationProgram(newTP);
                    transformationUnit.setComposite(true);
                    transformationUnit.setId("0");
                    ArrayList<Source> sources = new ArrayList<Source>();
                    Source source = new Source();
                    source.setContentType(tUSourceContentType);
                    source.setTransformationUnit(transformationUnit);
                    source.setInputID("TRInput0");
                    sources.add(source);
                    Target target = new Target();
                    target.setContentType(tUTargetContentType);
                    target.setTransformationUnit(transformationUnit);
                    target.setOutputID("TROutput");
                    transformationUnit.setSources(sources);
                    transformationUnit.setTarget(target);
                    ArrayList<ExtTransformationUnit> exttransformations = new ArrayList<ExtTransformationUnit>();
                    for (int i = 0; i < mincostpath.getPath().size(); ++i) {
                        TEdge edge = mincostpath.getPath().get(i);
                        log.info("pid=\"" + edge.getTransformationUnit().getTransformationProgram().getId() + "\" - tid=\"" + edge.getTransformationUnit().getId() + "\"");
                        for (Parameter param : mincostpath.getSUnbound(edge)) {
                            log.info("s_" + param.getName() + ": " + param.getValue());
                        }
                        for (Parameter param : mincostpath.getTUnbound(edge)) {
                            log.info("t_" + param.getName() + ": " + param.getValue());
                        }
                        ExtTransformationUnit exttransformation = new ExtTransformationUnit();
                        exttransformation.setTransformationUnit(transformationUnit);
                        exttransformation.setReferencedTransformationProgramID(edge.getTransformationUnit().getTransformationProgram().getId());
                        exttransformation.setReferencedTransformationUnitID(edge.getTransformationUnit().getId());
                        TargetHandlerDesc targetInputDataHandlerDesc = new TargetHandlerDesc();
                        targetInputDataHandlerDesc.setTargetID(edge.getTransformationUnit().getSources().get(0).getInputID());
                        if (i == 0) {
                            targetInputDataHandlerDesc.setThisID("TRInput0");
                        } else {
                            targetInputDataHandlerDesc.setThisID("TRBridge" + (i - 1));
                        }
                        targetInputDataHandlerDesc.setType("TargetInput");
                        TargetHandlerDesc targetOutputDataHandlerDesc = new TargetHandlerDesc();
                        targetOutputDataHandlerDesc.setTargetID(edge.getTransformationUnit().getTarget().getOutputID());
                        if (i == mincostpath.getPath().size() - 1) {
                            targetOutputDataHandlerDesc.setThisID("TROutput");
                        } else {
                            targetOutputDataHandlerDesc.setThisID("TRBridge" + i);
                        }
                        targetOutputDataHandlerDesc.setType("TargetOutput");
                        ArrayList<TargetHandlerDesc> targetHandlerDescs = new ArrayList<TargetHandlerDesc>();
                        targetHandlerDescs.add(targetInputDataHandlerDesc);
                        targetHandlerDescs.add(targetOutputDataHandlerDesc);
                        exttransformation.setTargetIOs(targetHandlerDescs);
                        if (consistencyLevel.equals((Object)Consistency.SUPPORT)) {
                            if (i != mincostpath.getPath().size() - 1) {
                                exttransformation.setUnboundContentTypeParameters(mincostpath.getTUnbound(edge));
                            }
                        } else if (consistencyLevel.equals((Object)Consistency.GENERIC) && i != mincostpath.getPath().size() - 1) {
                            exttransformation.setUnboundContentTypeParameters(mincostpath.getTUnbound(edge));
                        }
                        exttransformations.add(exttransformation);
                    }
                    transformationUnit.setExtTransformationList(exttransformations);
                    ArrayList<TransformationUnit> tUnits = new ArrayList<TransformationUnit>();
                    tUnits.add(transformationUnit);
                    newTP.setTransformationUnits(tUnits);
                    try {
                        this.imanager.publishTransformationProgram(newTP);
                        transformationUnits.add(transformationUnit);
                    }
                    catch (Exception e) {
                        log.error("Could not publish the transformationUnit program");
                    }
                    try {
                        this.addTransformationProgramInGraph(newTP, this.nodes);
                    }
                    catch (Exception e) {
                        log.error("Could not add in the graph the newly created transformationUnit program", (Throwable)e);
                    }
                }
            }
        }
        return transformationUnits;
    }

    protected static enum Consistency {
        EXACT,
        SUPPORT,
        GENERIC;

    }
}

