/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary;

import java.util.ArrayList;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.DataSourceRetriever;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceMerger
extends Thread {
    private List<DataSourceRetriever> retrievers = new ArrayList<DataSourceRetriever>();
    private DataSink sink;
    private boolean finishedAddingSources = false;
    private Object retrieversLock = new Object();
    private static Logger log = LoggerFactory.getLogger(DataSourceMerger.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DataSourceMerger dataSourceMerger = this;
            synchronized (dataSourceMerger) {
                while (this.retrievers.size() < 1 && !this.finishedAddingSources) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        log.error("Someone interrupted me...");
                    }
                }
                if (this.retrievers.size() > 0) {
                    log.info("At least one retriever is appended to the merger...");
                    while (!this.finishedAddingSources || !this.allHaveEnded()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            log.error("Someone interrupted me...");
                        }
                    }
                    log.info("All the transformed data have been appended in the sink...");
                } else {
                    log.warn("No retrievre has been appended so normally no transformationUnit performed...");
                }
            }
        }
        catch (Exception e) {
            log.error("Error in DataSourceMerger", (Throwable)e);
        }
        finally {
            if (this.sink != null) {
                log.info("DataSourceMerger is closing the common sink");
                this.sink.close();
            }
        }
    }

    private boolean allHaveEnded() {
        for (DataSourceRetriever retriever : this.retrievers) {
            if (retriever.hasEnded) continue;
            return false;
        }
        return true;
    }

    public synchronized void finishedAddingSources() {
        this.finishedAddingSources = true;
        log.info("Have finished adding sources in the DataSourceMerger...");
        this.notifyAll();
    }

    public synchronized boolean add(DataSource source) {
        DataSourceRetriever retriever = new DataSourceRetriever();
        retriever.source = source;
        retriever.sink = this.sink;
        retriever.sinklock = this.retrieversLock;
        retriever.mergerLock = this;
        retriever.start();
        boolean ret = this.retrievers.add(retriever);
        if (this.retrievers.size() == 1) {
            this.notifyAll();
        }
        return ret;
    }

    public void setSink(DataSink sink) {
        this.sink = sink;
    }
}

