/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs;

import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Elm2ElmProgram
implements Program {
    private static Logger log = LoggerFactory.getLogger(Elm2ElmProgram.class);

    @Override
    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (!sink.isClosed() && source.hasNext()) {
            log.debug("Source has next...");
            DataElement sourceDataElement = source.next();
            if (sourceDataElement != null) {
                DataElement transformedDataElement;
                try {
                    log.debug("Got next object with id " + sourceDataElement.getId());
                    transformedDataElement = this.transformDataElement(sourceDataElement, programParameters, targetContentType);
                    if (transformedDataElement == null) {
                        log.warn("Got null transformed object");
                        throw new NullPointerException();
                    }
                    transformedDataElement.setId(sourceDataElement.getId());
                    log.debug("Got transformed object with id: " + transformedDataElement.getId() + " and content type: " + transformedDataElement.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord(sourceDataElement.getId(), "Data element with id " + sourceDataElement.getId() + " and content type " + sourceDataElement.getContentType().toString() + " " + "was transformed successfully to " + transformedDataElement.getContentType().toString(), Record.Status.SUCCESSFUL, Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord(sourceDataElement.getId(), "Data element with id " + sourceDataElement.getId() + " and content type " + sourceDataElement.getContentType().toString() + " " + "could not be transformed to " + targetContentType.toString(), Record.Status.FAILED, Record.Type.TRANSFORMATION);
                    continue;
                }
                sourceDataElement.destroy();
                sink.append(transformedDataElement);
                log.debug("Transformed object with id: " + transformedDataElement.getId() + ", was appended successfully");
                continue;
            }
            log.warn("Got null object from the data source");
        }
        log.debug("Source does not have any objects left, closing the sink...");
        sink.close();
    }

    public abstract DataElement transformDataElement(DataElement var1, List<Parameter> var2, ContentType var3) throws Exception;
}

