/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.statistics;

import java.util.HashMap;
import java.util.Map;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;

public class StatisticsManager {
    private static HashMap<MetricType, HashMap<String, Metric>> metricsByType = new HashMap();
    private static HashMap<String, Metric> dtsSourceMetrics = new HashMap();
    private static HashMap<String, Metric> dataSourceMetrics = new HashMap();
    private static HashMap<String, Metric> transformationMetrics = new HashMap();
    private static HashMap<String, Metric> dataSinkMetrics = new HashMap();

    public static Metric getMetric(String name, MetricType mType) {
        return metricsByType.get((Object)mType).get(name);
    }

    public static synchronized Metric createMetric(String name, String description, MetricType mType) {
        Metric metric = new Metric(name, description);
        metricsByType.get((Object)mType).put(name, metric);
        return metric;
    }

    public static synchronized Metric createMetric(String name, String description, MetricType mType, int maxNumMeasures) {
        Metric metric = new Metric(name, description, maxNumMeasures);
        metricsByType.get((Object)mType).put(name, metric);
        return metric;
    }

    public static HashMap<String, Metric> getAllMetricsOfType(MetricType mType) {
        return metricsByType.get((Object)mType);
    }

    public static synchronized String toXML() {
        Metric metric;
        String metricName;
        StringBuilder buf = new StringBuilder();
        buf.append("<Statistics>");
        buf.append("<text>");
        buf.append("This section summarizes some statistical information about the service");
        buf.append("</text>");
        buf.append("<DTS>");
        for (Map.Entry<String, Metric> metricEntry : dtsSourceMetrics.entrySet()) {
            metricName = metricEntry.getKey();
            metric = metricEntry.getValue();
            buf.append("<");
            buf.append(metricName);
            buf.append(">");
            buf.append("<description>");
            buf.append(metric.getDescription());
            buf.append("</description>");
            buf.append("<MinValue>");
            buf.append(metric.getMinMeasure());
            buf.append("</MinValue>");
            buf.append("<MaxValue>");
            buf.append(metric.getMaxMeasure());
            buf.append("</MaxValue>");
            buf.append("<MeanValue>");
            buf.append(metric.getMeanOfMeasures());
            buf.append("</MeanValue>");
            buf.append("</");
            buf.append(metricName);
            buf.append(">");
        }
        buf.append("</DTS>");
        buf.append("<DataSources>");
        for (Map.Entry<String, Metric> metricEntry : dataSourceMetrics.entrySet()) {
            metricName = metricEntry.getKey();
            metric = metricEntry.getValue();
            buf.append("<");
            buf.append(metricName);
            buf.append(">");
            buf.append("<description>");
            buf.append(metric.getDescription());
            buf.append("</description>");
            buf.append("<MinValue>");
            buf.append(metric.getMinMeasure());
            buf.append("</MinValue>");
            buf.append("<MaxValue>");
            buf.append(metric.getMaxMeasure());
            buf.append("</MaxValue>");
            buf.append("<MeanValue>");
            buf.append(metric.getMeanOfMeasures());
            buf.append("</MeanValue>");
            buf.append("</");
            buf.append(metricName);
            buf.append(">");
        }
        buf.append("</DataSources>");
        buf.append("<Transformers>");
        for (Map.Entry<String, Metric> metricEntry : transformationMetrics.entrySet()) {
            metricName = metricEntry.getKey();
            metric = metricEntry.getValue();
            buf.append("<");
            buf.append(metricName);
            buf.append(">");
            buf.append("<description>");
            buf.append(metric.getDescription());
            buf.append("</description>");
            buf.append("<MinValue>");
            buf.append(metric.getMinMeasure());
            buf.append("</MinValue>");
            buf.append("<MaxValue>");
            buf.append(metric.getMaxMeasure());
            buf.append("</MaxValue>");
            buf.append("<MeanValue>");
            buf.append(metric.getMeanOfMeasures());
            buf.append("</MeanValue>");
            buf.append("</");
            buf.append(metricName);
            buf.append(">");
        }
        buf.append("</Transformers>");
        buf.append("<DataSinks>");
        for (Map.Entry<String, Metric> metricEntry : dataSinkMetrics.entrySet()) {
            metricName = metricEntry.getKey();
            metric = metricEntry.getValue();
            buf.append("<");
            buf.append(metricName);
            buf.append(">");
            buf.append("<description>");
            buf.append(metric.getDescription());
            buf.append("</description>");
            buf.append("<MinValue>");
            buf.append(metric.getMinMeasure());
            buf.append("</MinValue>");
            buf.append("<MaxValue>");
            buf.append(metric.getMaxMeasure());
            buf.append("</MaxValue>");
            buf.append("<MeanValue>");
            buf.append(metric.getMeanOfMeasures());
            buf.append("</MeanValue>");
            buf.append("</");
            buf.append(metricName);
            buf.append(">");
        }
        buf.append("</DataSinks>");
        buf.append("</Statistics>");
        return buf.toString();
    }

    static {
        metricsByType.put(MetricType.DTS, dtsSourceMetrics);
        metricsByType.put(MetricType.SOURCE, dataSourceMetrics);
        metricsByType.put(MetricType.TRANSFORMER, transformationMetrics);
        metricsByType.put(MetricType.SINK, dataSinkMetrics);
    }

    public static enum MetricType {
        DTS,
        SOURCE,
        TRANSFORMER,
        SINK;

    }
}

