/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.deployer;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.gcube.datatransformation.datatransformationlibrary.model.SoftwarePackage;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSProgramDeployer {
    private String DTS_LIBS_PATH;
    private URLClassLoader depClassLoader;
    private File dtsLibsPathFile;
    private File dtsDeployedPkgsFile;
    private static final String DEPLOYED_PKGS_FILE_NAME = "dts_deployed_pkgs";
    private static Logger log = LoggerFactory.getLogger(DTSProgramDeployer.class);
    private HashSet<String> deployedPackages = new HashSet();
    private static Metric deployPackageMetric = StatisticsManager.createMetric("DeployPackageMetric", "Time to deploy a package", StatisticsManager.MetricType.DTS);
    private FileFilter fileFilter = new WildcardFilter("*.jar");

    public static void main(String[] args) throws Exception {
        ArrayList<SoftwarePackage> packages = new ArrayList<SoftwarePackage>();
        SoftwarePackage pkg1 = new SoftwarePackage();
        pkg1.setId("package_apache_poi");
        pkg1.setLocation(new URL("http://dl07.di.uoa.gr:8080/programs/apachepoi_library.tar.gz"));
        packages.add(pkg1);
        SoftwarePackage pkg2 = new SoftwarePackage();
        pkg2.setId("package_apache_pdf");
        pkg2.setLocation(new URL("http://dl07.di.uoa.gr:8080/programs/apachepdf_library.tar.gz"));
        packages.add(pkg2);
        SoftwarePackage pkg3 = new SoftwarePackage();
        pkg3.setId("dts_programs_bundle");
        pkg3.setLocation(new URL("http://dl07.di.uoa.gr:8080/programs/dts_programs_bundle.tar.gz"));
        packages.add(pkg3);
        SoftwarePackage pkg4 = new SoftwarePackage();
        pkg4.setId("package_ij_lib");
        pkg4.setLocation(new URL("http://dl07.di.uoa.gr:8080/programs/ij_library.tar.gz"));
        packages.add(pkg4);
        new DTSProgramDeployer(args[0]).deployPackages(packages);
    }

    public String getDTSLibsPath() {
        return this.DTS_LIBS_PATH;
    }

    public DTSProgramDeployer(String DTS_LIBS_PATH) throws Exception {
        if (!DTS_LIBS_PATH.endsWith(File.separator)) {
            DTS_LIBS_PATH = DTS_LIBS_PATH + File.separator;
        }
        this.dtsLibsPathFile = new File(DTS_LIBS_PATH);
        if (!this.dtsLibsPathFile.exists() && !this.dtsLibsPathFile.mkdirs()) {
            throw new Exception("Did not manage to create DTS_LIBS_PATH for given path: " + DTS_LIBS_PATH);
        }
        this.dtsDeployedPkgsFile = new File(DTS_LIBS_PATH + DEPLOYED_PKGS_FILE_NAME);
        if (!this.dtsDeployedPkgsFile.exists()) {
            if (!this.dtsDeployedPkgsFile.createNewFile()) {
                throw new Exception("Did not manage to create dtsDeployedPkgsFile: " + DTS_LIBS_PATH + DEPLOYED_PKGS_FILE_NAME);
            }
        } else {
            this.checkInstalledPackages();
        }
        this.DTS_LIBS_PATH = DTS_LIBS_PATH;
        this.updateClassLoader();
    }

    private void checkInstalledPackages() throws Exception {
        try {
            String deployedPackage;
            FileInputStream fstream = new FileInputStream(this.dtsDeployedPkgsFile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((deployedPackage = br.readLine()) != null) {
                log.debug("Found installed package: " + deployedPackage);
                this.deployedPackages.add(deployedPackage);
            }
            in.close();
        }
        catch (Exception e) {
            log.error("Did not manage to check if deployed packages exist", (Throwable)e);
            throw new Exception("Did not manage to check if deployed packages exist", e);
        }
    }

    public synchronized void deployPackages(ArrayList<SoftwarePackage> packages) throws Exception {
        for (SoftwarePackage swrPackage : packages) {
            Process process;
            if (this.isPackageDeployed(swrPackage.getId())) {
                log.trace("Package " + swrPackage.getId() + " is already deployed");
                continue;
            }
            long startTime = System.currentTimeMillis();
            String packageID = swrPackage.getId();
            URL packageLocation = swrPackage.getLocation();
            log.debug("Deploying package " + packageID + "...");
            log.debug("This package will be fetched from " + packageLocation);
            try {
                FileUtils.copyURLToFile((URL)packageLocation, (File)new File(this.DTS_LIBS_PATH + packageID + File.separator + packageID + ".tar.gz"));
                log.debug("Package downloaded successfully to file " + this.DTS_LIBS_PATH + packageID);
            }
            catch (Exception e) {
                log.error("Did not manage to save package file into DTS_LIBS_PATH", (Throwable)e);
                throw new Exception("Did not manage to save package file into DTS_LIBS_PATH", e);
            }
            try {
                process = Runtime.getRuntime().exec(this.DTS_LIBS_PATH + "deployScript.sh " + packageID + " " + this.DTS_LIBS_PATH);
            }
            catch (Exception e) {
                log.error("Execution of the deploy script failed", (Throwable)e);
                throw new Exception("Execution of the deploy script failed", e);
            }
            int returnCode = process.waitFor();
            if (returnCode != 0) {
                log.error("Execution of the deploy script failed: Return code = " + returnCode);
                throw new Exception("Execution of the deploy script failed: Return code = " + returnCode);
            }
            log.debug("Execution of the deploy script succeeded");
            this.deployedPackages.add(packageID);
            FileUtils.writeLines((File)this.dtsDeployedPkgsFile, (String)"UTF-8", this.deployedPackages);
            this.updateClassLoader();
            deployPackageMetric.addMeasure(System.currentTimeMillis() - startTime);
        }
    }

    private boolean isPackageDeployed(String packageID) {
        return this.deployedPackages.contains(packageID);
    }

    private void updateClassLoader() throws Exception {
        File[] files;
        log.debug("Updating the DTS Class loader...");
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this.dtsLibsPathFile.toURL());
        for (File file : files = this.dtsLibsPathFile.listFiles(this.fileFilter)) {
            log.trace("Putting " + file.getAbsolutePath() + " into class loaders urls");
            urls.add(file.toURL());
        }
        this.depClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.depClassLoader;
    }
}

