/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model.graph;

import java.util.ArrayList;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.NodesCollection;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.Path;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TEdge;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TNode;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TNodeWithUnbound;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraphImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFinder {
    private ArrayList<TNode> visited = new ArrayList();
    private Path currpath = new Path();
    private ArrayList<Path> paths = null;
    private TNodeWithUnbound tnode;
    private NodesCollection nodes = null;
    private TransformationsGraphImpl.Consistency consistencyLevel = null;
    private static Logger log = LoggerFactory.getLogger(PathFinder.class);

    protected ArrayList<Path> getPaths(TNodeWithUnbound snode, TNodeWithUnbound tnode, TransformationsGraphImpl.Consistency consistencyLevel, NodesCollection nodes) {
        this.paths = new ArrayList();
        this.tnode = tnode;
        this.nodes = nodes;
        this.consistencyLevel = consistencyLevel;
        this.search(snode);
        return this.paths;
    }

    private void search(TNodeWithUnbound curnode) {
        if (curnode.getNode().equals(this.tnode.getNode())) {
            if (this.currpath.size() == 0) {
                log.warn("Target and current nodes are the same but path size is 0. We are searching from the same to the same node. These occasions may be checked in adnvance...");
                return;
            }
            Path newpath = this.currpath.clone();
            TEdge last = newpath.getPath().get(newpath.size() - 1);
            newpath.putTUnbound(last, this.tnode.getUnbound());
            this.paths.add(newpath);
            return;
        }
        for (TEdge edge : curnode.getNode().getEdges()) {
            ArrayList<Object> tosearch;
            if (this.consistencyLevel.equals((Object)TransformationsGraphImpl.Consistency.EXACT)) {
                tosearch = new ArrayList<TNodeWithUnbound>();
                tosearch.add(new TNodeWithUnbound(edge.getToNode(), null));
            } else if (this.consistencyLevel.equals((Object)TransformationsGraphImpl.Consistency.SUPPORT)) {
                tosearch = this.nodes.getAnyThatSupportWithUnbound(edge.getToNode());
                ArrayList<TNodeWithUnbound> tosearchby = this.nodes.getAnySupportedByWithUnbound(edge.getToNode());
                for (TNodeWithUnbound tNodeWithUnbound : tosearchby) {
                    boolean exists = false;
                    for (TNodeWithUnbound tNodeWithUnbound2 : tosearch) {
                        if (!tNodeWithUnbound2.getNode().equals(tNodeWithUnbound.getNode())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    tosearch.add(tNodeWithUnbound);
                }
            } else {
                tosearch = this.consistencyLevel.equals((Object)TransformationsGraphImpl.Consistency.GENERIC) ? this.nodes.getGenericallySupported(edge.getToNode()) : new ArrayList();
            }
            for (TNodeWithUnbound tNodeWithUnbound : tosearch) {
                if (this.visited.contains(tNodeWithUnbound.getNode())) continue;
                this.visited.add(tNodeWithUnbound.getNode());
                this.currpath.add(edge);
                if (curnode.isRefToSource()) {
                    this.currpath.putSUnbound(edge, curnode.getUnbound());
                }
                if (tNodeWithUnbound.isRefToTarget()) {
                    this.currpath.putTUnbound(edge, tNodeWithUnbound.getUnbound());
                }
                this.currpath.addCost(edge.getCost());
                this.search(tNodeWithUnbound);
                this.visited.remove(tNodeWithUnbound.getNode());
                this.currpath.remove(edge);
                if (curnode.isRefToSource()) {
                    this.currpath.removeSUnbound(edge);
                }
                if (tNodeWithUnbound.isRefToTarget()) {
                    this.currpath.removeTUnbound(edge);
                }
                this.currpath.subCost(edge.getCost());
            }
        }
    }
}

