package org.gcube.datatransformation.datatransformationlibrary.datahandlers.model;

import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;

/**
 * The Input is a wrap of a DataSource.
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class Input {
	private String inputType;
	private String inputValue;
	private Parameter[] inputparameters;

	public Input() {
	}

	public Input(String inputType, String inputValue, Parameter[] inputparameters) {
		this.inputType = inputType;
		this.inputValue = inputValue;
		this.inputparameters = inputparameters;
	}

	/**
	 * Gets the inputType value for this Input.
	 * 
	 * @return inputType
	 */
	public String getInputType() {
		return inputType;
	}

	/**
	 * Sets the inputType value for this Input.
	 * 
	 * @param inputType
	 */
	public void setInputType(String inputType) {
		this.inputType = inputType;
	}

	/**
	 * Gets the inputValue value for this Input.
	 * 
	 * @return inputValue
	 */
	public String getInputValue() {
		return inputValue;
	}

	/**
	 * Sets the inputValue value for this Input.
	 * 
	 * @param inputValue
	 */
	public void setInputValue(String inputValue) {
		this.inputValue = inputValue;
	}

	/**
	 * Gets the inputparameters value for this Input.
	 * 
	 * @return inputparameters
	 */
	public Parameter[] getInputparameters() {
		return inputparameters;
	}

	/**
	 * Sets the inputparameters value for this Input.
	 * 
	 * @param inputparameters
	 */
	public void setInputparameters(Parameter[] inputparameters) {
		this.inputparameters = inputparameters;
	}

	/**
	 * Gets the i'th {@link Parameter} from inputparameters
	 * 
	 * @param i
	 *            Index of the parameter
	 * @return The {@link Parameter}
	 */
	public Parameter getInputparameters(int i) {
		return this.inputparameters[i];
	}

	/**
	 * Sets the i'th {@link Parameter} to inputparameters
	 * 
	 * @param i
	 *            Index of the parameter
	 * @param _value
	 *            The {@link Parameter} to be set.
	 */
	public void setInputparameters(int i, Parameter _value) {
		this.inputparameters[i] = _value;
	}

	private Object __equalsCalc = null;

	public synchronized boolean equals(Object obj) {
		if (!(obj instanceof Input))
			return false;
		Input other = (Input) obj;
		if (obj == null)
			return false;
		if (this == obj)
			return true;
		if (__equalsCalc != null) {
			return (__equalsCalc == obj);
		}
		__equalsCalc = obj;
		boolean _equals;
		_equals = true
				&& ((this.inputType == null && other.getInputType() == null) || (this.inputType != null && this.inputType.equals(other.getInputType())))
				&& ((this.inputValue == null && other.getInputValue() == null) || (this.inputValue != null && this.inputValue.equals(other.getInputValue())))
				&& ((this.inputparameters == null && other.getInputparameters() == null) || (this.inputparameters != null && java.util.Arrays.equals(
						this.inputparameters, other.getInputparameters())));
		__equalsCalc = null;
		return _equals;
	}

	private boolean __hashCodeCalc = false;

	public synchronized int hashCode() {
		if (__hashCodeCalc) {
			return 0;
		}
		__hashCodeCalc = true;
		int _hashCode = 1;
		if (getInputType() != null) {
			_hashCode += getInputType().hashCode();
		}
		if (getInputValue() != null) {
			_hashCode += getInputValue().hashCode();
		}
		if (getInputparameters() != null) {
			for (int i = 0; i < java.lang.reflect.Array.getLength(getInputparameters()); i++) {
				Object obj = java.lang.reflect.Array.get(getInputparameters(), i);
				if (obj != null && !obj.getClass().isArray()) {
					_hashCode += obj.hashCode();
				}
			}
		}
		__hashCodeCalc = false;
		return _hashCode;
	}
}
