/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.security;

import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.ISManager;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraphImpl;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DTSGHNConsumer
extends GCUBEResource.ResourceConsumer {
    private static Logger log = LoggerFactory.getLogger(DTSGHNConsumer.class);

    DTSGHNConsumer() {
    }

    protected void onAddScope(GCUBEResource.AddScopeEvent event) {
        log.debug("Scopes were added...");
        GCUBEScope[] addedScopes = (GCUBEScope[])event.getPayload();
        if (addedScopes != null && addedScopes.length > 0) {
            for (GCUBEScope scope : addedScopes) {
                if (DTSSManager.dCoreMap.get(scope) != null) {
                    log.warn("Instance for scope " + scope + " already exist");
                    continue;
                }
                try {
                    log.debug("Going to create dCore instance for scope " + scope);
                    ISManager imanager = new ISManager();
                    imanager.setScope(scope);
                    TransformationsGraphImpl graph = new TransformationsGraphImpl(imanager);
                    DTSCore dcore = new DTSCore(imanager, graph);
                    DTSSManager.dCoreMap.put(scope, dcore);
                }
                catch (Exception e) {
                    log.error("Could not create DTSCore Instance for scope " + scope, (Throwable)e);
                }
            }
        } else {
            log.warn("Add scope event but with empty payload");
        }
    }

    protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
        log.debug("Scopes were removed...");
        GCUBEScope[] removedScopes = (GCUBEScope[])event.getPayload();
        if (removedScopes != null && removedScopes.length > 0) {
            for (GCUBEScope scope : removedScopes) {
                if (DTSSManager.dCoreMap.get(scope) == null) {
                    log.warn("Instance for scope " + scope + " does not exist");
                    continue;
                }
                try {
                    log.debug("Going to remove dCore instance for scope " + scope);
                    DTSSManager.dCoreMap.get(scope).destroy();
                    DTSSManager.dCoreMap.remove(scope);
                }
                catch (Exception e) {
                    log.error("Could not remove DTSCore Instance for scope " + scope);
                }
            }
        } else {
            log.warn("Remove scope event but with empty payload");
        }
    }
}

