/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Stream2StreamProgram;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.gcube.datatransformation.datatransformationlibrary.utils.FilesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class P2PProgram
extends Stream2StreamProgram {
    private static Logger log = LoggerFactory.getLogger(P2PProgram.class);
    private String subdir = null;

    @Override
    public InputStream transformStream(InputStream content, ContentType sourceFormat, List<Parameter> progparameters, ContentType targetContentType) throws Exception {
        if (this.subdir == null) {
            this.subdir = TempFileManager.genarateTempSubDir();
        }
        String inputfile = TempFileManager.generateTempFileName(this.subdir);
        try {
            FilesUtils.streamToFile(content, inputfile);
        }
        catch (Exception e) {
            log.error("Could not persist input to file", (Throwable)e);
            throw new Exception("Could not persist input to file", e);
        }
        String outputfile = TempFileManager.generateTempFileName(this.subdir);
        FileInputStream outputstream = null;
        try {
            outputstream = new FileInputStream(this.transformObjectFromItsPath(inputfile, progparameters, targetContentType, outputfile));
        }
        catch (Exception e) {
            log.error("Could not transform data", (Throwable)e);
            throw new Exception("Could not transform data", e);
        }
        return outputstream;
    }

    public abstract String transformObjectFromItsPath(String var1, List<Parameter> var2, ContentType var3, String var4) throws Exception;
}

