/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model;

import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Parameter {
    private String name = null;
    private String value = null;
    private boolean isOptional = false;

    public Parameter() {
    }

    public Parameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equalsIgnoreCase(other.value));
    }

    public static boolean equals(List<Parameter> params1, List<Parameter> params2) {
        if (params1 == null && params2 == null) {
            return true;
        }
        if (params1 == null && params2.size() == 0) {
            return true;
        }
        if (params2 == null && params1.size() == 0) {
            return true;
        }
        if (params1 == null && params2.size() > 0) {
            return false;
        }
        if (params2 == null && params1.size() > 0) {
            return false;
        }
        if (params1.size() == 0 && params2.size() == 0) {
            return true;
        }
        if (params1.size() != params2.size()) {
            return false;
        }
        for (Parameter param : params1) {
            if (Parameter.parameterExist(param, params2)) continue;
            return false;
        }
        return true;
    }

    public static boolean parameterExist(Parameter paramtofind, List<Parameter> inparameters) {
        if (paramtofind == null || inparameters == null) {
            return false;
        }
        for (Parameter tmpparam : inparameters) {
            if (!tmpparam.equals(paramtofind)) continue;
            return true;
        }
        return false;
    }

    public static boolean parameterNameExist(String parameterName, Parameter[] parametersToSearch) {
        if (parameterName == null || parametersToSearch == null) {
            return false;
        }
        for (Parameter tmpparam : parametersToSearch) {
            if (!tmpparam.getName().equalsIgnoreCase(parameterName)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.isOptional ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.toLowerCase().hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.toLowerCase().hashCode());
        return result;
    }

    public static int hashCode(List<Parameter> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return 1231;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            for (int j = 0; j < parameters.size() - 1; ++j) {
                if (parameters.get((int)j).name.toLowerCase().compareTo(parameters.get((int)(j + 1)).name.toLowerCase()) <= 0) continue;
                Parameter tmp = parameters.get(j);
                parameters.set(j, parameters.get(j + 1));
                parameters.set(j + 1, tmp);
            }
        }
        int PRIME = 31;
        int result = 1;
        for (Parameter param : parameters) {
            result = 31 * result + param.hashCode();
        }
        return result;
    }

    protected void toDOM(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element param = doc.createElement("Parameter");
        Attr pname = doc.createAttribute("name");
        pname.setNodeValue(this.getName());
        Attr pvalue = doc.createAttribute("value");
        pvalue.setNodeValue(this.getValue());
        Attr isOptional = doc.createAttribute("isOptional");
        isOptional.setTextContent(String.valueOf(this.isOptional()));
        param.setAttributeNode(pname);
        param.setAttributeNode(pvalue);
        param.setAttributeNode(isOptional);
        parent.appendChild(param);
    }

    public String toString() {
        return this.getName() + "=\"" + this.getValue() + "\"";
    }
}

