/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.imanagers;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.ContentTypeCondition;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.ContentTypeQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.DescriptionQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.ProgramParametersQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.QueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.QueryParser;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.TransformationUnitQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationProgram;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ISManager
implements IManager {
    private static Logger log = LoggerFactory.getLogger(ISManager.class);
    private GCUBEScope scope;

    @Override
    public String[] getAvailableTransformationProgramIDs() throws Exception {
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
            query.addParameters(new QueryParameter[]{new QueryParameter("TYPE", "GenericResource"), new QueryParameter("FILTER", "$result/Profile/SecondaryType/string() eq 'DTSTransformationProgram'"), new QueryParameter("RESULT", "$result/ID/text()")});
            List results = client.execute((ISQuery)query, this.scope);
            if (results.size() == 0) {
                log.warn("Did not manage to find any available transformationUnit programs");
                return new String[0];
            }
            ArrayList<String> trProgramIDs = new ArrayList<String>();
            for (XMLResult result : results) {
                log.debug("Found transformationUnit program \"" + result.toString().trim() + "\"");
                trProgramIDs.add(result.toString().trim());
            }
            return trProgramIDs.toArray(new String[trProgramIDs.size()]);
        }
        catch (Exception e) {
            log.error("Could not invoke IS to find the available transformationUnit program IDs", (Throwable)e);
            throw new Exception("Could not invoke IS to find the available transformationUnit program IDs");
        }
    }

    @Override
    public TransformationProgram getTransformationProgram(String transformationProgramID) throws Exception {
        GCUBEGenericResource resource;
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            if (transformationProgramID.startsWith("$")) {
                String transformationProgramName = transformationProgramID.substring(1);
                log.debug("Going to get Progarm with name " + transformationProgramName + " from scope " + this.scope.toString());
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", transformationProgramName)});
            } else {
                log.debug("Going to get Progarm with ID " + transformationProgramID + " from scope " + this.scope.toString());
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", transformationProgramID)});
            }
            List results = client.execute((ISQuery)query, this.scope);
            if (results == null || results.size() == 0) {
                log.error("Could not find transformationUnit program with id " + transformationProgramID);
                throw new Exception("Could not find transformationUnit program with id " + transformationProgramID);
            }
            resource = (GCUBEGenericResource)results.get(0);
        }
        catch (Exception e) {
            log.error("Could not invoke IS to find the transformationUnit program with id " + transformationProgramID, (Throwable)e);
            throw new Exception("Could not invoke IS to find the transformationUnit program with id " + transformationProgramID);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            ByteArrayInputStream instream = new ByteArrayInputStream(resource.getBody().getBytes());
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document resourceDoc = builder.parse(instream);
            TransformationProgram programinst = new TransformationProgram();
            programinst.fromDOM(resourceDoc.getDocumentElement());
            programinst.setId(resource.getID());
            programinst.setName(resource.getName());
            programinst.setDescription(resource.getDescription());
            return programinst;
        }
        catch (Exception e) {
            log.error("Could not parse the resource(Transformation Program)", (Throwable)e);
            throw new Exception("Could not parse the resource(Transformation Program)");
        }
    }

    @Override
    public TransformationUnit getTransformationUnit(String transformationProgramID, String transformationUnitID) throws Exception {
        TransformationProgram transformationProgram = this.getTransformationProgram(transformationProgramID);
        if (transformationProgram.getTransformationUnits() == null || transformationProgram.getTransformationUnits().size() == 0) {
            log.error("Transformation program with id " + transformationProgramID + " does not contain any transformationUnit Units");
            throw new Exception("Transformation program with id " + transformationProgramID + " does not contain any transformationUnit Units");
        }
        for (TransformationUnit transformationUnit : transformationProgram.getTransformationUnits()) {
            if (!transformationUnit.getId().equals(transformationUnitID)) continue;
            return transformationUnit;
        }
        log.error("Did not manage to find transformationUnit Unit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
        throw new Exception("Did not manage to find transformationUnit Unit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
    }

    @Override
    public void publishTransformationProgram(TransformationProgram transformationProgram) throws Exception {
        String transformationProgramToXML = transformationProgram.toXML();
        log.debug("Publishing in IS Transformation Program\n" + transformationProgramToXML);
        GCUBEGenericResource resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
        resource.load((Reader)new StringReader(transformationProgramToXML));
        log.debug("TPID " + resource.getID());
        log.debug("TPName " + resource.getName());
        log.debug("TPType " + resource.getType());
        log.debug("TPBody " + resource.getBody());
        resource.addScope(new GCUBEScope[]{this.scope});
        ISPublisher publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        publisher.registerGCUBEResource((GCUBEResource)resource, this.scope, DTSSManager.getSecurityManager());
    }

    @Override
    public String queryTransformationPrograms(String query) throws Exception {
        QueryObject object = QueryParser.parse(query);
        String result = null;
        if (ContentTypeQueryObject.class.isInstance(object)) {
            log.debug("Quering for Content Types...");
            ContentTypeQueryObject ctobject = (ContentTypeQueryObject)object;
            result = this.queryContentType(ctobject);
        } else if (TransformationUnitQueryObject.class.isInstance(object)) {
            log.debug("Quering for Transformations...");
            TransformationUnitQueryObject tuobject = (TransformationUnitQueryObject)object;
            result = this.queryTransformationUnit(tuobject);
        } else if (DescriptionQueryObject.class.isInstance(object)) {
            log.debug("Quering for Description...");
            DescriptionQueryObject tobject = (DescriptionQueryObject)object;
            result = this.queryDescription(tobject);
        } else if (ProgramParametersQueryObject.class.isInstance(object)) {
            log.debug("Quering for program parameters...");
            ProgramParametersQueryObject ppobject = (ProgramParametersQueryObject)object;
            result = this.queryProgramParameters(ppobject);
        } else {
            log.debug("Invalid query object type");
            throw new Exception("Invalid query object type");
        }
        log.debug("Result of query: " + query + " is \n" + result);
        return result;
    }

    private String queryProgramParameters(ProgramParametersQueryObject object) throws Exception {
        log.debug("Going to get program parameters for " + object.transformationProgramID);
        if (object.transformationProgramID == null || object.transformationProgramID.trim().length() == 0) {
            throw new Exception("Cannot query for description without setting transformationUnit program id");
        }
        TransformationProgram tp = this.getTransformationProgram(object.transformationProgramID);
        StringBuilder result = new StringBuilder();
        result.append("<Result>");
        if (tp.getTransformer().getGlobalProgramParams() != null || tp.getTransformer().getGlobalProgramParams().size() > 0) {
            for (Parameter param : tp.getTransformer().getGlobalProgramParams()) {
                result.append("<Parameter isOptional=\"" + param.isOptional() + "\" name=\"" + param.getName() + "\" value=\"" + param.getValue() + "\"/>");
            }
        }
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            TransformationUnit selected = null;
            for (TransformationUnit tu : tp.getTransformationUnits()) {
                if (!tu.getId().equals(object.transformationUnitID)) continue;
                selected = tu;
                break;
            }
            if (selected == null) {
                throw new Exception("Could not find transformationUnit with id " + object.transformationUnitID + " in TransformationProgram " + object.transformationProgramID);
            }
            for (Parameter param : selected.getProgramParameters()) {
                result.append("<Parameter isOptional=\"" + param.isOptional() + "\" name=\"" + param.getName() + "\" value=\"" + param.getValue() + "\"/>");
            }
        }
        result.append("</Result>");
        return result.toString();
    }

    private String queryDescription(DescriptionQueryObject object) throws Exception {
        log.debug("Going to get description for " + object.transformationProgramID + "/" + object.transformationUnitID);
        if (object.transformationProgramID == null || object.transformationProgramID.trim().length() == 0) {
            throw new Exception("Cannot query for description without setting transformationUnit program id");
        }
        TransformationProgram tp = this.getTransformationProgram(object.transformationProgramID);
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            TransformationUnit selected = null;
            for (TransformationUnit tu : tp.getTransformationUnits()) {
                if (!tu.getId().equals(object.transformationUnitID)) continue;
                selected = tu;
                break;
            }
            if (selected == null) {
                throw new Exception("Could not find transformationUnit with id " + object.transformationUnitID + " in TransformationProgram " + object.transformationProgramID);
            }
            ArrayList<TransformationUnit> tUnits = new ArrayList<TransformationUnit>();
            tUnits.add(selected);
            tp.setTransformationUnits(tUnits);
        }
        return "<Result>" + tp.toXML() + "</Result>";
    }

    private String queryTransformationUnit(TransformationUnitQueryObject object) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
        boolean putAnd = false;
        StringBuilder expression = new StringBuilder();
        expression.append("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; ");
        expression.append("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; ");
        expression.append("for $result in collection('/db/Profiles/GenericResource')//Document/Data/is:Profile/Resource ");
        expression.append("where $result/Profile/SecondaryType/string() eq 'DTSTransformationProgram' ");
        if (object.transformationProgramID != null && object.transformationProgramID.trim().length() > 0) {
            expression.append("and $result/ID/string() eq '" + object.transformationProgramID + "'");
        }
        expression.append(" return ");
        expression.append("for $resultin in $result/Profile/Body/gDTSTransformationProgram/TransformationUnits/TransformationUnit ");
        if (object.sourceContentTypeConditions != null && object.sourceContentTypeConditions.size() > 0 || object.targetContentTypeConditions != null && object.targetContentTypeConditions.size() > 0) {
            expression.append("where ");
            if (object.sourceContentTypeConditions != null && object.sourceContentTypeConditions.size() > 0) {
                for (ContentTypeCondition fcondition : object.sourceContentTypeConditions.values()) {
                    if (putAnd) {
                        expression.append(" and ");
                    }
                    putAnd = true;
                    if (fcondition.getMimetype() == null || fcondition.getMimesubtype() == null) {
                        if (fcondition.getMimetype() != null) {
                            expression.append("starts-with($resultin/Sources/Source/ContentType/Mimetype/string(), '" + fcondition.getMimetype() + "/') ");
                        }
                        if (fcondition.getMimesubtype() == null) continue;
                        expression.append("ends-with($resultin/Sources/Source/ContentType/Mimetype/string(), '/" + fcondition.getMimesubtype() + "') ");
                        continue;
                    }
                    expression.append("$resultin/Sources/Source/ContentType/Mimetype/string() eq '" + fcondition.getMimetype() + "/" + fcondition.getMimesubtype() + "' ");
                }
            }
            if (object.targetContentTypeConditions != null && object.targetContentTypeConditions.size() > 0) {
                for (ContentTypeCondition fcondition : object.targetContentTypeConditions.values()) {
                    if (putAnd) {
                        expression.append(" and ");
                    }
                    putAnd = true;
                    if (fcondition.getMimetype() == null || fcondition.getMimesubtype() == null) {
                        if (fcondition.getMimetype() != null) {
                            expression.append("starts-with($resultin/Target/ContentType/Mimetype/string(), '" + fcondition.getMimetype() + "/') ");
                        }
                        if (fcondition.getMimesubtype() == null) continue;
                        expression.append("ends-with($resultin/Target/ContentType/Mimetype/string(), '/" + fcondition.getMimesubtype() + "') ");
                        continue;
                    }
                    expression.append("$resultin/Target/ContentType/Mimetype/string() eq '" + fcondition.getMimetype() + "/" + fcondition.getMimesubtype() + "' ");
                }
            }
        }
        expression.append("return <TransformationUnit><TransformationProgramID>{$result/ID/string()}</TransformationProgramID><TransformationUnitID>{$resultin/string(@id)}</TransformationUnitID></TransformationUnit>");
        query.setExpression(expression.toString());
        List results = client.execute((ISQuery)query, this.scope);
        StringBuilder finalresult = new StringBuilder();
        finalresult.append("<Result>");
        for (XMLResult result : results) {
            log.debug("XMLRESULT\n" + result);
            finalresult.append(result.toString());
        }
        finalresult.append("</Result>");
        return finalresult.toString();
    }

    private String queryContentType(ContentTypeQueryObject object) throws Exception {
        StringBuilder expression = new StringBuilder();
        expression.append("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; ");
        expression.append("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; ");
        expression.append("for $result in collection('/db/Profiles/GenericResource')//Document/Data/is:Profile/Resource ");
        expression.append("where $result/Profile/SecondaryType/string() eq 'DTSTransformationProgram' ");
        if (object.transformationProgramID != null && object.transformationProgramID.trim().length() > 0) {
            expression.append("and $result/ID/string() eq '" + object.transformationProgramID + "'");
        }
        expression.append(" return ");
        expression.append("for $resultin in $result/Profile/Body/gDTSTransformationProgram/TransformationUnits/TransformationUnit");
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            expression.append("[string(@id) eq '" + object.transformationUnitID + "']");
        }
        if (object.getResultType().equals("SCONTENTTYPE")) {
            expression.append("/Sources/Source ");
        } else {
            expression.append("/Target ");
        }
        System.out.println("Mimetype: " + object.contentTypeCondition.getMimetype());
        System.out.println("SubMimetype: " + object.contentTypeCondition.getMimesubtype());
        if (object.contentTypeCondition.getMimetype() == null || object.contentTypeCondition.getMimesubtype() == null) {
            if (object.contentTypeCondition.getMimetype() != null) {
                expression.append("where starts-with($resultin/ContentType/Mimetype/string(), '" + object.contentTypeCondition.getMimetype() + "/') ");
            }
            if (object.contentTypeCondition.getMimesubtype() != null) {
                expression.append("where ends-with($resultin/ContentType/Mimetype/string(), '/" + object.contentTypeCondition.getMimesubtype() + "') ");
            }
        } else {
            expression.append("where $resultin/ContentType/Mimetype/string() eq '" + object.contentTypeCondition.getMimetype() + "/" + object.contentTypeCondition.getMimesubtype() + "' ");
        }
        expression.append("return $resultin/ContentType");
        return this.queryContentFormatByExpression(expression.toString());
    }

    private String queryContentFormatByExpression(String expression) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
        query.setExpression(expression);
        List results = client.execute((ISQuery)query, this.scope);
        if (results == null || results.size() == 0) {
            log.info("No results found");
            return "<Result/>";
        }
        StringBuilder strbuilder = new StringBuilder();
        strbuilder.append("<Result>");
        for (XMLResult result : results) {
            log.debug("Adding to doc: " + result.toString());
            strbuilder.append(result.toString());
        }
        strbuilder.append("</Result>");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            HashSet<Integer> exist = new HashSet<Integer>();
            ByteArrayInputStream instream = new ByteArrayInputStream(strbuilder.toString().getBytes());
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(instream);
            Element resultElement = (Element)doc.getElementsByTagName("Result").item(0);
            NodeList nlist = doc.getElementsByTagName("ContentType");
            log.debug("#Results(Dublicate): " + nlist.getLength());
            ArrayList<Element> elmsToRemove = new ArrayList<Element>();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Element cformat = (Element)nlist.item(i);
                ContentType format = new ContentType();
                format.fromDOM(cformat);
                log.debug("ContentType: " + format.toString() + ", hashCode: " + format.hashCode());
                if (!exist.contains(format.hashCode())) {
                    log.debug("Adding: " + format.toString());
                    exist.add(format.hashCode());
                    continue;
                }
                log.debug("Removing: " + format.toString());
                elmsToRemove.add(cformat);
            }
            for (Element elm : elmsToRemove) {
                resultElement.removeChild(elm);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (SAXException e) {
            log.error("Could not parse results document " + strbuilder.toString(), (Throwable)e);
            throw new Exception("Could not parse results document " + strbuilder.toString());
        }
        catch (TransformerException e) {
            log.error("Could not serialize document", (Throwable)e);
            throw new Exception("Could not serialize document");
        }
        catch (Exception e) {
            log.error("Could not execute query", (Throwable)e);
            throw new Exception("Could not execute query: " + e.getMessage());
        }
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public void setScope(GCUBEScope scope) {
        if (scope == null) {
            log.error("Cannot set null scope to the ISManager");
            return;
        }
        log.debug("Setting scope " + scope.toString() + " to ISManager");
        this.scope = scope;
    }
}

