/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.FilterDataBridge;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilterThread
extends Thread {
    protected FilterDataBridge filterbridge;
    private static Logger log = LoggerFactory.getLogger(FilterThread.class);

    FilterThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.filterbridge.source.hasNext()) {
                try {
                    DataElement object = this.filterbridge.source.next();
                    if (object == null) continue;
                    log.debug("Filtering object with id " + object.getId() + " and content type " + object.getContentType().toString());
                    if (object.getContentType().equals(this.filterbridge.filterContentType) || ContentType.support(this.filterbridge.filterContentType, object.getContentType()) || ContentType.gensupport(this.filterbridge.filterContentType, object.getContentType())) {
                        log.debug("Object with ID " + object.getId() + " NOT filtered");
                        ReportManager.manageRecord(object.getId(), "Object with id " + object.getId() + " and content type " + object.getContentType().toString() + " passed the filter", Record.Status.SUCCESSFUL, Record.Type.FILTER);
                        this.filterbridge.append(object);
                        continue;
                    }
                    log.debug("Object with ID " + object.getId() + " FILTERED");
                    ReportManager.manageRecord(object.getId(), "Object with id " + object.getId() + " and content type " + object.getContentType().toString() + " was filtered", Record.Status.FAILED, Record.Type.FILTER);
                }
                catch (Exception e) {
                    log.debug("Error in filtering an object, continuing...", (Throwable)e);
                }
            }
            log.debug("Filtering finished successfully");
            return;
        }
        catch (Exception e) {
            log.error("Undefined exception in filtering the data source", (Throwable)e);
            return;
        }
        finally {
            this.filterbridge.close();
        }
    }
}

