/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils.stax;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.datatransformation.datatransformationlibrary.DTSScope;
import org.gcube.datatransformation.datatransformationlibrary.utils.stax.StaxResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxReader {
    private static Logger log = LoggerFactory.getLogger(StaxReader.class);
    private XMLStreamReader streamReader;
    private String currPath;
    private Set<String> pathsSet;
    private Set<String> allPathsSet;

    public StaxReader(Set<String> pathsSet, URL url) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("gcube-scope", DTSScope.getScope());
        this.streamReader = inputFactory.createXMLStreamReader(urlConnection.getInputStream());
        this.currPath = "/";
        this.allPathsSet = new HashSet<String>();
        for (String path : pathsSet) {
            this.allPathsSet.add(path);
            while (!path.isEmpty()) {
                this.allPathsSet.add(path);
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        this.pathsSet = pathsSet;
    }

    public boolean hasNext() {
        try {
            return this.streamReader.hasNext();
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    public StaxResponse next() {
        try {
            while (this.streamReader.hasNext()) {
                this.streamReader.next();
                if (this.streamReader.isStartElement()) {
                    String startElement = this.streamReader.getLocalName();
                    this.currPath = this.currPath + (this.currPath.endsWith("/") ? "" : "/") + startElement;
                    if (this.allPathsSet.contains(this.currPath)) {
                        if (!this.pathsSet.contains(this.currPath)) continue;
                        String text = null;
                        try {
                            text = this.streamReader.getElementText();
                        }
                        catch (Exception e) {
                            text = StaxReader.getValue(this.streamReader);
                        }
                        StaxResponse resp = new StaxResponse(text, this.currPath);
                        if (this.currPath.endsWith(startElement)) {
                            this.currPath = this.currPath.substring(0, this.currPath.lastIndexOf("/"));
                        }
                        if (this.currPath.isEmpty()) {
                            this.currPath = "/";
                        }
                        return resp;
                    }
                }
                if (!this.streamReader.isEndElement()) continue;
                String endElement = this.streamReader.getLocalName();
                if (this.currPath.endsWith(endElement)) {
                    this.currPath = this.currPath.substring(0, this.currPath.lastIndexOf("/"));
                }
                if (!this.currPath.isEmpty()) continue;
                this.currPath = "/";
            }
        }
        catch (XMLStreamException e) {
            log.warn("will return null", (Throwable)e);
            return null;
        }
        return null;
    }

    public void close() {
        try {
            this.streamReader.close();
        }
        catch (XMLStreamException e) {
            log.warn("could not close inputstream", (Throwable)e);
        }
    }

    private static String getValue(XMLStreamReader xsr) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new StAXSource(xsr), new StreamResult(sw));
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
        return sw.toString();
    }
}

