/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.URLDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DistributableDataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIListDataSource
implements DataSource,
DistributableDataSource,
ContentTypeDataSource {
    private BufferedReader br;
    private File temp;
    private boolean hasNext = true;
    private static Logger log = LoggerFactory.getLogger(URIListDataSource.class);
    private boolean isClosed = false;

    public static void main(String[] args) throws Exception {
        URIListDataSource dataSource = new URIListDataSource("http://node1.d.efg.research-infrastructures.eu/urls/list.txt", null);
        int cnt = 0;
        while (dataSource.hasNext()) {
            DataElement elm = dataSource.next();
            ++cnt;
            if (elm == null) continue;
            System.out.println("---" + elm.getId());
        }
        System.out.println("Got " + cnt + " data elements");
    }

    public URIListDataSource(String input, Parameter[] inputParameters) throws Exception {
        String inputLine;
        this.temp = File.createTempFile("list", ".URIlist");
        FileOutputStream fileoutputstream = new FileOutputStream(this.temp);
        DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);
        URL uriListLocation = new URL(input);
        DataInputStream in = new DataInputStream(uriListLocation.openStream());
        this.br = new BufferedReader(new InputStreamReader(in));
        while ((inputLine = this.br.readLine()) != null) {
            dataoutputstream.writeBytes(inputLine + "\n");
        }
        dataoutputstream.flush();
        dataoutputstream.close();
        FileInputStream fileinputstream = new FileInputStream(this.temp);
        this.br = new BufferedReader(new InputStreamReader(fileinputstream));
        this.br.close();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public DataElement next() {
        try {
            String nextElement = this.br.readLine();
            if (nextElement != null) {
                log.trace("Returning element to get from url " + nextElement);
                String name = null;
                String URL2 = nextElement;
                if (nextElement.startsWith("\"")) {
                    int URLstart = nextElement.indexOf(34) + 1;
                    int URLend = nextElement.indexOf(34, URLstart + 1);
                    int nameStart = nextElement.indexOf(34, URLend + 1) + 1;
                    int nameEnd = nextElement.lastIndexOf(34);
                    URL2 = nextElement.substring(URLstart, URLend);
                    name = nextElement.substring(nameStart, nameEnd);
                    log.trace("URL: " + URL2 + " output filename: " + name);
                }
                URLDataElement next = new URLDataElement(URL2);
                if (name != null) {
                    next.setAttribute("DocumentName", name);
                }
                return next;
            }
            log.trace("No more elements");
            this.hasNext = false;
            return null;
        }
        catch (Exception e) {
            log.trace("URLList got exception: ", (Throwable)e);
            this.hasNext = false;
            return null;
        }
    }

    public void close() {
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.temp.delete();
                this.br.close();
            }
        }
        catch (Exception e) {
            log.error("Did not manage to clear rs reader", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public DataElement getDataElement(String dataElementID) throws Exception {
        return new URLDataElement(dataElementID);
    }

    public String getNextDataElementID() throws Exception {
        try {
            String nextElement = this.br.readLine();
            if (nextElement != null) {
                log.trace("Returning element with url " + nextElement);
                return nextElement;
            }
            this.hasNext = false;
            return null;
        }
        catch (Exception e) {
            this.hasNext = false;
            return null;
        }
    }

    public URIListDataSource() {
    }

    public void initializeDistributableDataSource(String input, Parameter[] inputParameters) throws Exception {
    }

    public ContentType nextContentType() {
        DataElement de = this.next();
        return de == null ? null : de.getContentType();
    }
}

