/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.DTSScope;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.LocalFileDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.WorkspaceItemRef;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceDataSource
implements DataSource,
ContentTypeDataSource {
    private String collectionID = "workspace";
    private DataBridge bridge = DTSCore.getDataBridge();
    private static Logger log = LoggerFactory.getLogger(WorkspaceDataSource.class);
    private String tmpDownloadDir;
    private Workspace ws = null;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private File nullFile;
    private List<String> users;
    private List<String> excludeUsers;
    private List<String> excludeMimetypes;
    private static final int MAX_FILE_LENGTH_SUPPPORTED = 64000000;
    private int maxFileLength = 64000000;
    private Set<String> visited = new HashSet<String>();
    private static final String extensionSeparator = ".";

    public WorkspaceDataSource(final String input, Parameter[] inputParameters) throws Exception {
        if (inputParameters != null) {
            for (Parameter param : inputParameters) {
                if (param.getName().equalsIgnoreCase("collectionid")) {
                    this.collectionID = param.getValue().trim();
                }
                if (param.getName().equalsIgnoreCase("limitusers")) {
                    this.users = Arrays.asList(param.getValue().trim().split(" *, *"));
                }
                if (param.getName().equalsIgnoreCase("excludeusers")) {
                    this.excludeUsers = Arrays.asList(param.getValue().trim().split(" *, *"));
                }
                if (param.getName().equalsIgnoreCase("excludemimetypes")) {
                    this.excludeMimetypes = Arrays.asList(param.getValue().trim().split(" *, *"));
                }
                if (!param.getName().equalsIgnoreCase("maxSize")) continue;
                this.maxFileLength = Integer.parseInt(param.getValue().trim());
            }
        }
        String scope = null;
        scope = DTSScope.getScope();
        if (scope != null) {
            ScopeProvider.instance.set(scope);
        }
        this.tmpDownloadDir = TempFileManager.genarateTempSubDir();
        log.debug("Managed to create temporary directory to " + this.tmpDownloadDir);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    this.setName("WorkspaceDataSource Retriever");
                    try {
                        HomeManager homeManager = HomeLibrary.getHomeManagerFactory().getHomeManager();
                        if (input != null && !input.trim().isEmpty()) {
                            List refs = (List)new Gson().fromJson(input, new TypeToken<List<WorkspaceItemRef>>(){}.getType());
                            for (WorkspaceItemRef ref : refs) {
                                WorkspaceDataSource.this.ws = homeManager.getHome(ref.user).getWorkspace();
                                WorkspaceDataSource.this.getItems(WorkspaceDataSource.this.ws.getItemByPath(ref.path), null);
                            }
                            break block8;
                        }
                        for (String user : WorkspaceDataSource.this.getUsers()) {
                            log.info("Retrieving stored workspace data from user: " + user);
                            Workspace ws = homeManager.getHome(user).getWorkspace();
                            WorkspaceDataSource.this.getItems((WorkspaceItem)ws.getRoot(), Arrays.asList(user));
                            if (!WorkspaceDataSource.this.bridge.isClosed()) continue;
                            log.error("Bridge was closed unexpectedly. Stop reading any more...");
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.error("Did not manage to fetch content from Workspace", (Throwable)e);
                    }
                    finally {
                        log.info("Finished retrieving objects from initial source");
                        WorkspaceDataSource.this.bridge.close();
                    }
                }
            }
        }.start();
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = null;
        try {
            de = this.bridge.next();
        }
        catch (Exception e) {
            log.error("Could not manage to fetch next object's content type", (Throwable)e);
        }
        return de == null ? null : de.getContentType();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() throws Exception {
        return this.bridge.next();
    }

    private void getItems(WorkspaceItem workspaceItem, List<String> accessList) throws RepositoryException, InternalErrorException {
        List<WorkspaceItem> children = workspaceItem.isFolder() ? workspaceItem.getChildren() : Arrays.asList(workspaceItem);
        for (WorkspaceItem child : children) {
            List childAL = accessList;
            if (child instanceof JCRWorkspaceSharedFolder) {
                JCRWorkspaceItem jcrWorkspaceItem = (JCRWorkspaceItem)child;
                if (this.visited.contains(jcrWorkspaceItem.getId())) {
                    log.info("Already visited shared folder: " + jcrWorkspaceItem.getPath() + ". skipping...");
                    return;
                }
                this.visited.add(jcrWorkspaceItem.getId());
                childAL = jcrWorkspaceItem.getUsers();
            }
            this.retrieveInfo(child, childAL);
            if (child.getChildren() != null && child.getChildren().size() > 0) {
                this.getItems(child, childAL);
            }
            if (!this.bridge.isClosed()) continue;
            break;
        }
    }

    private static String getFileExtention(String fileName) {
        int dot = fileName.lastIndexOf(extensionSeparator);
        if (dot == -1) {
            return null;
        }
        return fileName.substring(dot + 1);
    }

    private void retrieveInfo(WorkspaceItem item, List<String> usersACL) {
        String id = null;
        if (item instanceof ExternalFile) {
            LocalFileDataElement object = new LocalFileDataElement();
            ExternalFile file = (ExternalFile)item;
            try {
                id = file.getPublicLink(false);
                object.setId(id);
                if (this.excludeMimetypes != null && this.excludeMimetypes.contains(file.getMimeType())) {
                    log.info("File (" + file.getId() + ") has a mimetype (" + file.getMimeType() + ") to exclude from handling. Appending without content.");
                    this.nullFile = new File(TempFileManager.generateTempFileName(null));
                    this.nullFile.createNewFile();
                    object.setContent(this.nullFile);
                } else if (file.getLength() < (long)this.maxFileLength) {
                    String extention = WorkspaceDataSource.getFileExtention(file.getName());
                    String localFileName = TempFileManager.generateTempFileName((String)this.tmpDownloadDir);
                    if (extention != null) {
                        localFileName = localFileName + extensionSeparator + extention;
                    }
                    File localFile = new File(localFileName);
                    InputStream is = file.getData();
                    Files.copy(is, Paths.get(localFileName, new String[0]), new CopyOption[0]);
                    is.close();
                    object.setContent(localFile);
                } else {
                    log.info("File (" + file.getId() + ") has too big size (" + file.getLength() + ") to handle. Appending without content.");
                    this.nullFile = new File(TempFileManager.generateTempFileName(null));
                    this.nullFile.createNewFile();
                    object.setContent(this.nullFile);
                }
                object.setAttribute("CollectionID", this.collectionID);
                object.setAttribute("ContentOID", id);
                object.setAttribute("title", String.valueOf(file.getName()));
                object.setAttribute("size", String.valueOf(file.getLength()));
                object.setAttribute("creationDate", this.format.format(file.getCreationTime().getTime()));
                object.setAttribute("modificationDate", this.format.format(file.getLastModificationTime().getTime()));
                object.setAttribute("owner", String.valueOf(file.getOwner().getPortalLogin()));
                object.setAttribute("mimeType", file.getMimeType());
                object.setAttribute("workspaceItemID", file.getId());
                object.setAttribute("path", file.getPath());
                if (usersACL == null) {
                    if (item.isShared()) {
                        String sharedFolderId = item.getIdSharedFolder();
                        JCRWorkspaceSharedFolder sharedFolder = (JCRWorkspaceSharedFolder)this.ws.getItem(sharedFolderId);
                        usersACL = sharedFolder.getUsers();
                    } else {
                        usersACL = Arrays.asList(this.ws.getOwner().getPortalLogin());
                    }
                }
                for (int i = 0; i < usersACL.size(); ++i) {
                    object.setAttribute("sid" + i, (String)usersACL.get(i));
                }
                object.setContentType(new ContentType(file.getMimeType(), new ArrayList()));
                this.bridge.append((DataElement)object);
                log.trace("Object with id " + id + " and size " + file.getLength() + " was added for processing from Workspace");
                ReportManager.manageRecord((String)id, (String)("Object with id " + id + " was added for processing from Workspace"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
            }
            catch (Exception e) {
                log.warn("Could not manage to fetch the object " + id, (Throwable)e);
                ReportManager.manageRecord((String)id, (String)("Object with id " + id + " could not be fetched from Workspace"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
            }
        }
    }

    private List<String> getUsers() throws InternalErrorException, InterruptedException {
        if (this.users == null) {
            this.users = HomeLibrary.getHomeManagerFactory().getUserManager().getUsers();
            Collections.shuffle(this.users);
            if (this.excludeUsers != null) {
                ArrayList<String> inters = new ArrayList<String>();
                inters.addAll(this.users);
                inters.retainAll(this.excludeUsers);
                log.info("going to remove users: " + inters);
                this.users.removeAll(inters);
            }
        }
        log.info("users: " + this.users);
        return this.users;
    }
}

