/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils.queue;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gcube.datatransformation.datatransformationlibrary.utils.queue.FileBackedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFileBackedQueue<E extends Serializable>
extends AbstractQueue<E> {
    private static Logger log = LoggerFactory.getLogger(MemoryFileBackedQueue.class);
    private static final int DEFAULT_THRESHOLD = 10;
    private Queue<E> m_memoryQueue;
    private FileBackedQueue<E> m_fileQueue;
    private int m_threshold;
    private Object sync = new Object();
    private boolean finished = false;
    private long totalCnt = 0L;
    private long fbackedCnt = 0L;

    public MemoryFileBackedQueue() throws IOException {
        this(10);
    }

    public MemoryFileBackedQueue(int threshold) throws IOException {
        this.m_threshold = threshold;
        this.m_memoryQueue = new ConcurrentLinkedQueue();
        this.m_fileQueue = new FileBackedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        boolean retValue = false;
        Object object = this.sync;
        synchronized (object) {
            if (this.finished) {
                return false;
            }
        }
        ++this.totalCnt;
        if (this.m_threshold > this.m_memoryQueue.size() && this.m_fileQueue.size() == 0) {
            retValue = this.m_memoryQueue.offer(e);
        } else {
            ++this.fbackedCnt;
            retValue = this.m_fileQueue.offer(e);
        }
        object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object retValue = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.size() == 0) {
                try {
                    this.sync.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        retValue = this.m_memoryQueue.size() > 0 || this.m_fileQueue.size() == 0 ? (Serializable)this.m_memoryQueue.poll() : this.m_fileQueue.poll();
        return (E)retValue;
    }

    @Override
    public E peek() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.sync;
        synchronized (object) {
            return this.m_fileQueue.size() + this.m_memoryQueue.size();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            this.finished = true;
        }
        log.info("Total number of records: " + this.totalCnt + ". Number of records that were stored in file: " + this.fbackedCnt + ". Percentage: " + (this.totalCnt > 0L ? (double)this.fbackedCnt / (double)this.totalCnt * 100.0 : 0.0) + "% of records stored in file.");
        this.m_fileQueue.destroy();
        this.m_memoryQueue.clear();
    }
}

