/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.util.ArrayList;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.DTSScope;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.Record;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.utils.queue.MemoryFileBackedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDataSource
implements DataSource,
ContentTypeDataSource {
    private String treeCollectionID;
    private DataBridge bridge = DTSCore.getDataBridge();
    private static Logger log = LoggerFactory.getLogger(TMDataSource.class);
    private Stream<Tree> treesReader;
    private volatile boolean finished = false;
    private Object sync = new Object();
    private MemoryFileBackedQueue<Record> queue;

    public TMDataSource(String input, Parameter[] inputParameters) {
        this.treeCollectionID = input;
        String scope = null;
        scope = DTSScope.getScope();
        if (scope != null) {
            ScopeProvider.instance.set(scope);
        }
        log.debug("Going to fetch objects from tree manager with id: " + this.treeCollectionID + " under scope: " + scope);
        StatefulQuery query = TServiceFactory.readSource().withId(this.treeCollectionID).build();
        TReader treader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        this.treesReader = treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setName("TMDataSource");
                try {
                    TMDataSource.this.queue = new MemoryFileBackedQueue(100);
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            this.setName("TMDataSource Retriever");
                            log.info("File backed queue created for storing trees");
                            int i = 0;
                            try {
                                while (TMDataSource.this.treesReader.hasNext()) {
                                    log.trace("going to fetch tree #" + (i + 1));
                                    Tree t = (Tree)TMDataSource.this.treesReader.next();
                                    if (++i % 100 == 0) {
                                        log.debug("fetched " + i + " trees.");
                                    }
                                    log.trace("tree #" + i + " retrived");
                                    Record rec = new Record(t.uri().toASCIIString(), XMLBindings.toString((Tree)t), null);
                                    if (!TMDataSource.this.queue.offer(rec)) {
                                        log.error("Could not store retrieved tree");
                                        break;
                                    }
                                    Object object = TMDataSource.this.sync;
                                    synchronized (object) {
                                        TMDataSource.this.sync.notify();
                                    }
                                }
                                TMDataSource.this.treesReader.close();
                            }
                            catch (Exception e) {
                                log.info("An unexpected error occured while reading the stream from tm client", (Throwable)e);
                                Object object = TMDataSource.this.sync;
                                synchronized (object) {
                                    TMDataSource.this.finished = true;
                                    TMDataSource.this.sync.notify();
                                }
                                return;
                            }
                            log.info("Finished retrieving objects from initial source");
                            Object object = TMDataSource.this.sync;
                            synchronized (object) {
                                TMDataSource.this.finished = true;
                                TMDataSource.this.sync.notify();
                            }
                        }
                    }.start();
                    block8: while (!(TMDataSource.this.finished && TMDataSource.this.queue.size() <= 0 || TMDataSource.this.bridge.isClosed())) {
                        Object object = TMDataSource.this.sync;
                        synchronized (object) {
                            while (TMDataSource.this.queue.size() == 0 && !TMDataSource.this.finished) {
                                TMDataSource.this.sync.wait();
                                if (!TMDataSource.this.finished) continue;
                                continue block8;
                            }
                        }
                        Record rec = (Record)TMDataSource.this.queue.poll();
                        if (rec == null) {
                            log.warn("Queue returned null");
                            continue;
                        }
                        TMDataSource.this.manageObject(rec.getId(), rec.getPayload());
                    }
                }
                catch (Exception e) {
                    log.error("Did not manage to fetch content from tree manager", (Throwable)e);
                }
                finally {
                    log.info("Removing queue.");
                    TMDataSource.this.queue.destroy();
                    TMDataSource.this.bridge.close();
                }
            }
        }.start();
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = null;
        try {
            de = this.bridge.next();
        }
        catch (Exception e) {
            log.error("Could not manage to fetch next object's content type", (Throwable)e);
        }
        return de == null ? null : de.getContentType();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() throws Exception {
        return this.bridge.next();
    }

    private void manageObject(String id, String payload) {
        try {
            StrDataElement object = StrDataElement.getSourceDataElement();
            object.setId(id);
            object.setContent(payload);
            object.setAttribute("CollectionID", this.treeCollectionID);
            object.setAttribute("ContentOID", id);
            object.setContentType(new ContentType("application/xml", new ArrayList()));
            this.bridge.append((DataElement)object);
            log.trace("Object with id " + id + " was added for processing by TM");
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " was added for processing by TM"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + id, (Throwable)e);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " could not be fetched TM"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
        }
    }
}

