/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DTSExceptionWrapper;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.HTTPDataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;

public class SRUDataSource
implements DataSource,
ContentTypeDataSource {
    private static final String COLLECTION = "searchRetrieveResponse";
    private static final String RECORDS = "records";
    private static final String RECORD = "record";
    private static final String ID = "recordSchema";
    private static final String MIMETYPE = "recordPacking";
    private static final String PAYLOAD = "recordData";
    private static final String RECORDIDPATH = "/searchRetrieveResponse/records/record/recordSchema";
    private static final String FIELDMIMETYPEPATH = "/searchRetrieveResponse/records/record/recordPacking";
    private static final String FIELDPAYLOADPATH = "/searchRetrieveResponse/records/record/recordData";
    private HTTPDataSource source;

    public SRUDataSource(String input, Parameter[] inputParameters) throws XMLStreamException, IOException {
        ArrayList params = Lists.newArrayList((Object[])new Parameter[]{new Parameter(HTTPDataSource.CollPaths.COLLNAMEPATH.toString(), input), new Parameter(HTTPDataSource.CollPaths.COLLPROVENANCEPATH.toString(), input), new Parameter(HTTPDataSource.CollPaths.COLLTIMESTAMPPATH.toString(), new Date().toString()), new Parameter(HTTPDataSource.CollPaths.RECORDIDPATH.toString(), RECORDIDPATH), new Parameter(HTTPDataSource.CollPaths.FIELDMIMETYPEPATH.toString(), FIELDMIMETYPEPATH), new Parameter(HTTPDataSource.CollPaths.FIELDPAYLOADPATH.toString(), FIELDPAYLOADPATH)});
        if (inputParameters != null) {
            for (Parameter param : inputParameters) {
                params.add(param);
            }
        }
        this.source = new HTTPDataSource(input, params.toArray(new Parameter[params.size()]));
    }

    public void close() {
        this.source.close();
    }

    public boolean isClosed() {
        return this.source.isClosed();
    }

    public ContentType nextContentType() {
        ContentType ct = this.source.nextContentType();
        if (ct.getMimeType().equals("xml")) {
            ct.setMimeType("text/xml");
        }
        return ct;
    }

    public boolean hasNext() {
        return this.source.hasNext();
    }

    public DataElement next() throws Exception {
        DataElement de = this.source.next();
        if (de instanceof DTSExceptionWrapper) {
            throw new Exception(((DTSExceptionWrapper)de).getThrowable());
        }
        if (de.getContentType().getMimeType().equals("xml")) {
            de.getContentType().setMimeType("text/xml");
        }
        return de;
    }
}

