/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.LocalFileDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDataSource
implements DataSource,
ContentTypeDataSource {
    private boolean closed = false;
    String tmpDownloadDir;
    private List<String> elements;
    private static Logger log = LoggerFactory.getLogger(PushDataSource.class);

    public static void main(String[] args) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("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");
        list.add("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");
        PushDataSource ds = new PushDataSource(new Gson().toJson(list), null);
        while (ds.hasNext()) {
            DataElement dataElement = ds.next();
        }
    }

    public PushDataSource(String input, Parameter[] inputParameters) throws Exception {
        this.elements = (List)new Gson().fromJson(input, new TypeToken<List<String>>(){}.getType());
        this.tmpDownloadDir = TempFileManager.genarateTempSubDir();
        log.debug("Managed to create temporary directory to " + this.tmpDownloadDir);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        return !this.elements.isEmpty();
    }

    public DataElement next() {
        LocalFileDataElement elm = null;
        try {
            if (this.elements.isEmpty()) {
                throw new Exception("no more elements");
            }
            byte[] payload = Base64.decodeBase64((byte[])this.elements.remove(0).getBytes());
            String id = String.valueOf(payload.hashCode());
            String fileName = TempFileManager.generateTempFileName((String)this.tmpDownloadDir).replaceAll("\\.[^\\.]*$", "");
            Files.write(Paths.get(fileName, new String[0]), payload, new OpenOption[0]);
            elm = new LocalFileDataElement();
            elm.setContent(new File(fileName));
            elm.setAttribute("DocumentName", id);
            elm.setId(id);
            String mimeType = Files.probeContentType(Paths.get(fileName, new String[0]));
            elm.setContentType(new ContentType(mimeType, new ArrayList()));
        }
        catch (Exception e) {
            log.warn("Did not manage to get next element...");
        }
        return elm;
    }

    public void close() {
        this.closed = true;
    }

    public ContentType nextContentType() {
        DataElement de = this.next();
        return de == null ? null : de.getContentType();
    }
}

