/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DTSExceptionWrapper;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.RSDataElementUtil;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRS2DataSink
implements DataSink {
    private static Logger log = LoggerFactory.getLogger(GRS2DataSink.class);
    private RecordDefinition[] defs = null;
    private int wroterecs = 0;
    private boolean deleteOnDispose = false;
    private RecordWriter<GenericRecord> writer = null;
    private static File nullFile = null;
    private boolean isClosed = false;

    public GRS2DataSink(String output, Parameter[] outputParameters) throws Exception {
        if (outputParameters != null) {
            for (Parameter param : outputParameters) {
                if (param == null || param.getName() == null || param.getValue() == null || !param.getName().equalsIgnoreCase("deleteOnDispose")) continue;
                try {
                    this.deleteOnDispose = Boolean.parseBoolean(param.getValue());
                    log.debug("GRS2DataSink will be set with deleteOnDispose set to " + this.deleteOnDispose);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        nullFile = new File(TempFileManager.generateTempFileName(null));
        nullFile.createNewFile();
        FileFieldDefinition ffd = new FileFieldDefinition("File");
        ffd.setDeleteOnDispose(this.deleteOnDispose);
        this.defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition("Metadata"), ffd})};
        this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, 1L, TimeUnit.DAYS);
    }

    public void append(DataElement dataElement) {
        if (dataElement instanceof DTSExceptionWrapper) {
            int minutes = 1;
            try {
                while (!this.writer.put(((DTSExceptionWrapper)dataElement).getThrowable(), 1L, TimeUnit.MINUTES)) {
                    IBuffer.Status s = this.writer.getStatus();
                    log.debug("RS buffer full.... looping... " + dataElement.getId() + " status " + s.toString());
                    if (++minutes <= 10) continue;
                    log.warn("Transformation has remained idle for a long. Closing writer.");
                    this.close();
                    this.writer = null;
                    return;
                }
            }
            catch (GRS2WriterException e) {
                log.error("could not append exception", (Throwable)e);
            }
            return;
        }
        GenericRecord rec = new GenericRecord();
        try {
            File f;
            if (dataElement.getContent() == null) {
                if (this.deleteOnDispose) {
                    nullFile = new File(TempFileManager.generateTempFileName(null));
                    nullFile.createNewFile();
                } else {
                    nullFile.setLastModified(System.currentTimeMillis());
                }
                f = nullFile;
            } else {
                f = RSDataElementUtil.dataElementContentToFile(dataElement);
            }
            if (f != null && !f.exists()) {
                log.warn(f.getAbsolutePath() + " (No such file or directory)");
                return;
            }
            rec.setFields(new Field[]{new StringField(RSDataElementUtil.dataElementMetadataToXML(dataElement)), new FileField(f)});
            int minutes = 1;
            while (!this.writer.put((Record)rec, 1L, TimeUnit.MINUTES)) {
                IBuffer.Status s = this.writer.getStatus();
                log.debug("RS buffer full.... looping... " + dataElement.getId() + " status " + s.toString());
                if (++minutes <= 10) continue;
                log.warn("Transformation has remained idle for a long. Closing writer.");
                this.close();
                this.writer = null;
                return;
            }
            ++this.wroterecs;
            log.debug("Wrote record (" + this.wroterecs + ") #" + dataElement.getId());
        }
        catch (Exception e) {
            this.close();
            log.error("Failed to append RS2 element", (Throwable)e);
            return;
        }
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            try {
                log.debug("Total records added: " + this.writer.totalRecords());
            }
            catch (Exception e1) {
                // empty catch block
            }
            this.writer.close();
            ReportManager.closeReport();
        }
        catch (Exception e) {
            log.error("Could not close GRS2DataSink", (Throwable)e);
        }
    }

    public String getOutput() {
        try {
            return this.writer.getLocator().toASCIIString();
        }
        catch (Exception e) {
            log.error("Did not manage to create the RS Locator", (Throwable)e);
            return null;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

