/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils.stax;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.management.modelmbean.XMLParseException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.gcube.datatransformation.datatransformationlibrary.utils.stax.StaxResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxReader {
    private static Logger log = LoggerFactory.getLogger(StaxReader.class);
    private XMLEventReader eventReader;
    private String currPath;
    private Set<String> pathsSet;

    public StaxReader(Set<String> pathsSet, URL url) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        this.eventReader = inputFactory.createXMLEventReader(url.openStream());
        this.currPath = "/";
        this.pathsSet = pathsSet;
    }

    public boolean hasNext() {
        return this.eventReader.hasNext();
    }

    public StaxResponse next() {
        try {
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    this.currPath = this.currPath + (this.currPath.endsWith("/") ? "" : "/") + startElement.getName().getLocalPart();
                    if (this.pathsSet.contains(this.currPath)) {
                        event = this.eventReader.nextEvent();
                        if (!event.isCharacters()) {
                            log.warn("event: " + event + " is not characters");
                            continue;
                        }
                        StaxResponse resp = new StaxResponse(event.asCharacters().getData(), this.currPath);
                        return resp;
                    }
                }
                if (!event.isEndElement()) continue;
                EndElement endElement = event.asEndElement();
                if (!this.currPath.endsWith(endElement.getName().getLocalPart())) {
                    throw new XMLParseException("unkows closing element tag: " + endElement.getName().getLocalPart());
                }
                this.currPath = this.currPath.substring(0, this.currPath.lastIndexOf("/"));
                if (!this.currPath.isEmpty()) continue;
                this.currPath = "/";
            }
        }
        catch (XMLStreamException e) {
            log.warn("will return null", (Throwable)e);
            return null;
        }
        catch (XMLParseException e) {
            log.warn("will return null", (Throwable)e);
            return null;
        }
        return null;
    }
}

