/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.URLDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.REFDataBridge;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class URLDataSource
implements DataSource,
ContentTypeDataSource {
    private Logger log = LoggerFactory.getLogger(URLDataSource.class);
    private REFDataBridge objectsinfs = new REFDataBridge();

    public URLDataSource(String input, Parameter[] inputParameters) throws Exception {
        URL confURL = new URL(input);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(confURL.openStream());
        int i = 0;
        Element ObjectElement = null;
        while ((ObjectElement = (Element)doc.getElementsByTagName("DataElement").item(i++)) != null) {
            String id = ((Element)ObjectElement.getElementsByTagName("ID").item(0)).getTextContent();
            ContentType contentFormat = new ContentType();
            Element contentFormatElement = (Element)ObjectElement.getElementsByTagName("ContentType").item(0);
            String mimetype = ((Element)contentFormatElement.getElementsByTagName("Mimetype").item(0)).getTextContent();
            contentFormat.setMimeType(mimetype);
            Element formatparameters = (Element)contentFormatElement.getElementsByTagName("Parameters").item(0);
            if (formatparameters != null) {
                Element parameter;
                ArrayList<Parameter> contentTypeParametersList = new ArrayList<Parameter>();
                int cnt = 0;
                while ((parameter = (Element)formatparameters.getElementsByTagName("Parameter").item(cnt++)) != null) {
                    Parameter param = new Parameter();
                    param.setName(parameter.getAttribute("name"));
                    param.setValue(parameter.getAttribute("value"));
                    String isOptional = parameter.getAttribute("isOptional");
                    if (isOptional == null || isOptional.equalsIgnoreCase("true")) {
                        param.setOptional(true);
                    }
                    contentTypeParametersList.add(param);
                }
                contentFormat.setContentTypeParameters(contentTypeParametersList);
            }
            String url = ((Element)ObjectElement.getElementsByTagName("Location").item(0)).getTextContent();
            this.log.debug("Got URL object " + url + " with type " + contentFormat.toString());
            URLDataElement newURLObject = URLDataElement.getSourceDataElement();
            newURLObject.setId(id);
            newURLObject.setContentType(contentFormat);
            newURLObject.setContent(new URL(url));
            this.objectsinfs.append((DataElement)newURLObject);
        }
    }

    public boolean hasNext() {
        return this.objectsinfs.hasNext();
    }

    public DataElement next() {
        return this.objectsinfs.next();
    }

    public void close() {
        this.objectsinfs.close();
    }

    public boolean isClosed() {
        return this.objectsinfs.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = this.objectsinfs.next();
        return de == null ? null : de.getContentType();
    }
}

