/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSXMLDataSource
implements DataSource,
ContentTypeDataSource {
    private RSXMLIterator rsiterator;
    private RSXMLReader rsreader;
    private static Logger log = LoggerFactory.getLogger(RSXMLDataSource.class);
    private static String XMLMimeType = "text/xml";
    private boolean isClosed = false;

    public RSXMLDataSource(String RSEPR, Parameter[] inputParameters) throws Exception {
        log.info("Initialization of RS with RSEPR: " + RSEPR);
        try {
            this.rsreader = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(RSEPR)).makeLocalPatiently((RSResourceType)new RSResourceLocalType(), 1200000);
            this.rsiterator = this.rsreader.getRSIterator();
        }
        catch (Exception e) {
            log.error("Could not get RSXMLIterator ", (Throwable)e);
            throw new Exception("Could not get RSXMLIterator ", e);
        }
    }

    public boolean hasNext() {
        return this.rsiterator.hasNext();
    }

    public DataElement next() {
        String objectID = null;
        try {
            ResultElementGeneric rselement = (ResultElementGeneric)this.rsiterator.next(ResultElementGeneric.class);
            StrDataElement element = StrDataElement.getSourceDataElement();
            objectID = rselement.getRecordAttributes("DocID")[0].getAttrValue();
            String collID = rselement.getRecordAttributes("CollID")[0].getAttrValue();
            element.setId(objectID);
            ContentType contentType = new ContentType();
            contentType.setMimeType(XMLMimeType);
            element.setContentType(contentType);
            RecordAttribute[] attrs = rselement.getRecordAttributes();
            if (attrs != null && attrs.length > 0) {
                for (RecordAttribute attr : attrs) {
                    log.debug("Got record attribute from RSXML: " + attr.getAttrName() + " - " + attr.getAttrValue());
                    element.setAttribute(attr.getAttrName(), attr.getAttrValue());
                }
            } else {
                log.trace("Result set record does not contain any attributes");
            }
            element.setAttribute("ContentOID", objectID);
            element.setAttribute("MetadataColID", collID);
            element.setContent(rselement.getPayload());
            ReportManager.manageRecord((String)objectID, (String)("Object with id " + objectID + ", ReferencedCOID " + element.getAttributeValue("ContentOID") + " was successfully fetched by RS from MCollection"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
            return element;
        }
        catch (Exception e) {
            log.error("Did not manage to get data element from RS", (Throwable)e);
            ReportManager.manageRecord((String)objectID, (String)("Object with id " + objectID + " could not be fetched by RS from RSXML"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
            return null;
        }
    }

    public void close() {
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.rsreader.clear();
            }
        }
        catch (Exception e) {
            log.error("Did not manage to clear rs reader", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public ContentType nextContentType() {
        this.rsiterator.next(ResultElementGeneric.class);
        ContentType ct = new ContentType();
        ct.setMimeType(XMLMimeType);
        return ct;
    }
}

