/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSBLOBWriter;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.RSBlobDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.ResultSetDataElement;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSBlobDataSink
implements DataSink {
    private static Logger log = LoggerFactory.getLogger(RSBlobDataSource.class);
    private RSBLOBWriter writer;
    private boolean isClosed = false;

    public RSBlobDataSink(String output, Parameter[] outputParameters) {
        try {
            RSBLOBWriter writer;
            this.writer = writer = RSBLOBWriter.getRSBLOBWriter();
        }
        catch (Exception e) {
            log.error("Could not create RSBlobWriter", (Throwable)e);
        }
    }

    public String getOutput() {
        try {
            return this.writer.getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
        }
        catch (Exception e) {
            log.error("Could not get RS Locator", (Throwable)e);
            return null;
        }
    }

    public void append(DataElement element) {
        if (element == null || this.isClosed) {
            return;
        }
        try {
            log.debug("Inserting element with id " + element.getId());
            ResultSetDataElement rsElement = new ResultSetDataElement(element);
            this.writer.addResults((ResultElementBLOBBase)rsElement);
        }
        catch (Exception e) {
            log.error("Could not append object to result set", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.isClosed = true;
            ReportManager.closeReport();
            this.writer.close();
        }
        catch (Exception e) {
            log.error("Could not close writer", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

