/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.File;
import java.io.InputStream;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.utils.FilesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathDataSink
implements DataSink {
    private String sinkpath;
    private static Logger log = LoggerFactory.getLogger(PathDataSink.class);

    public PathDataSink(String output, Parameter[] outputParameters) {
        this.sinkpath = output.endsWith(File.separator) ? output : output + File.separator;
    }

    public void append(DataElement element) {
        if (element != null) {
            try {
                String filename = element.getId().hashCode() + element.getContentType().getMimeType().replaceAll("/", ".");
                log.info("Trying to persist stream into file " + this.sinkpath + filename);
                FilesUtils.streamToFile((InputStream)element.getContent(), (String)(this.sinkpath + filename));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
    }

    public String getOutput() {
        return this.sinkpath;
    }

    public boolean isClosed() {
        return false;
    }
}

