/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.dataelements.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.activation.MimetypesFileTypeMap;
import javax.activation.URLDataSource;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLDataElement
extends DataElement
implements Serializable {
    private static final long serialVersionUID = 1712943374738652846L;
    private static Logger log = LoggerFactory.getLogger(URLDataElement.class);
    private URL url;

    public static URLDataElement getSourceDataElement() {
        return new URLDataElement();
    }

    public URLDataElement(String url) throws Exception {
        this.url = new URL(url);
        this.setId(url);
    }

    private URLDataElement() {
    }

    public InputStream getContent() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            log.error("Could not open stream of the object with url " + this.url.toString());
            return null;
        }
    }

    public void setContent(URL url) {
        this.url = url;
    }

    public ContentType getContentType() {
        if (super.getContentType() == null) {
            URLDataSource urlDS = new URLDataSource(this.url);
            ContentType contentFormat = new ContentType();
            String contentTypeEvalueated = urlDS.getContentType();
            log.trace("The content type of " + this.url + " is " + contentTypeEvalueated);
            if (contentTypeEvalueated.equalsIgnoreCase("application/octet-stream")) {
                log.trace("The content type of " + this.url + " was not detected properly");
                contentTypeEvalueated = new MimetypesFileTypeMap().getContentType(this.url.toString());
                log.trace("The content type of " + this.url + " is reset to be " + contentTypeEvalueated);
            }
            contentFormat.setMimeType(contentTypeEvalueated);
            this.setContentType(contentFormat);
        }
        return super.getContentType();
    }

    public void destroy() {
        this.url = null;
    }
}

