/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils.queue;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Iterator;

public class FileBackedQueue<E extends Serializable>
extends AbstractQueue<E> {
    private static final String DEFAULT_FILENAME = "queuestorage";
    private File queueStorage;
    private ObjectInput input;
    private ObjectOutput output;
    private volatile int size = 0;
    private boolean initialized = false;

    public FileBackedQueue() throws IOException {
        this(DEFAULT_FILENAME);
    }

    public FileBackedQueue(String filename) throws IOException {
        this.queueStorage = File.createTempFile(filename, ".tmp");
        this.queueStorage.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(this.queueStorage);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        this.output = new ObjectOutputStream(bos);
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized E poll() {
        Serializable e = null;
        try {
            if (this.size <= 0) {
                this.wait(6000L);
            }
            if (this.size > 0) {
                if (!this.initialized) {
                    FileInputStream fis = new FileInputStream(this.queueStorage);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    this.input = new ObjectInputStream(bis);
                    this.initialized = true;
                }
                e = (Serializable)this.input.readObject();
                --this.size;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return (E)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.input.close();
            this.output.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (this.queueStorage.exists()) {
                this.queueStorage.delete();
            }
        }
    }

    @Override
    public synchronized boolean offer(E e) {
        try {
            this.output.writeObject(e);
            this.output.flush();
            ++this.size;
            this.notifyAll();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public E peek() {
        return (E)this.poll();
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }
}

