/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.DataElementImpl;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;

public class ResultSetDataElement
extends ResultElementBLOBBase {
    private static final String OID = "oid";
    private static final String MIMETYPE = "mimetype";
    private static final String FORMATPREFIX = "fmt_";
    private static final String ATTRIBUTEPREFIX = "att_";
    private String payload;
    private InputStream content;

    public ResultSetDataElement() {
    }

    public ResultSetDataElement(DataElement dataElement) throws Exception {
        Vector<RecordAttribute> at = new Vector<RecordAttribute>();
        at.add(new RecordAttribute(OID, dataElement.getId()));
        at.add(new RecordAttribute(MIMETYPE, dataElement.getContentType().getMimeType()));
        if (dataElement.getContentType().getContentTypeParameters() != null) {
            for (Parameter param : dataElement.getContentType().getContentTypeParameters()) {
                at.add(new RecordAttribute(FORMATPREFIX + param.getName(), param.getValue()));
            }
        }
        for (String attrName : dataElement.getAllAttributes().keySet()) {
            at.add(new RecordAttribute(ATTRIBUTEPREFIX + attrName, dataElement.getAttributeValue(attrName)));
        }
        this.setRecordAttributes(at.toArray(new RecordAttribute[at.size()]));
        this.payload = null;
        this.content = dataElement.getContent();
    }

    private void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getOID() {
        return this.getRecordAttributes(OID)[0].getAttrValue();
    }

    public ContentType getContentType() {
        RecordAttribute[] attrs;
        ContentType format = new ContentType();
        format.setMimeType(this.getRecordAttributes(MIMETYPE)[0].getAttrValue());
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (RecordAttribute attr : attrs = this.getRecordAttributes()) {
            if (!attr.getAttrName().startsWith(FORMATPREFIX)) continue;
            Parameter param = new Parameter();
            param.setName(attr.getAttrName().substring(FORMATPREFIX.length()));
            param.setValue(attr.getAttrValue());
            params.add(param);
        }
        format.setContentTypeParameters(params);
        return format;
    }

    public DataElement getDataElement() {
        RecordAttribute[] attrs;
        DataElementImpl element = DataElementImpl.getSourceDataElement();
        element.setId(this.getOID());
        element.setContentType(this.getContentType());
        for (RecordAttribute attr : attrs = this.getRecordAttributes()) {
            if (!attr.getAttrName().startsWith(ATTRIBUTEPREFIX)) continue;
            element.setAttribute(attr.getAttrName().substring(ATTRIBUTEPREFIX.length()), attr.getAttrValue());
        }
        element.setContent(this.content);
        return element;
    }

    public void close() throws Exception {
        try {
            this.content.close();
        }
        catch (Exception e) {
            throw new Exception("Could not close the underlying stream", e);
        }
    }

    public void setContentOfBLOB(InputStream content) throws Exception {
        this.content = content;
    }

    public InputStream getContentOfBLOB() throws Exception {
        return this.content;
    }

    public String toXML() throws Exception {
        return this.payload;
    }

    public void fromXML(String xml) throws Exception {
        try {
            this.setPayload(xml);
        }
        catch (Exception e) {
            throw new Exception("provided xml string is not valid ResultSelement serialization", e);
        }
    }
}

