/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.LocalFileDataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.URLDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DistributableDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.FTPDataSink;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPDataSource
implements DataSource,
DistributableDataSource,
ContentTypeDataSource {
    protected static final String PARAMETER_DirectoryName = "directory";
    protected static final String PARAMETER_Username = "username";
    protected static final String PARAMETER_Password = "password";
    protected static final String PARAMETER_Port = "port";
    private static Logger log = LoggerFactory.getLogger(FTPDataSource.class);
    private static Metric ftpDownloadObjectMetric = StatisticsManager.createMetric((String)"FTPDownloadObjectMetric", (String)"Time to download file from FTP Location", (StatisticsManager.MetricType)StatisticsManager.MetricType.SOURCE);
    private static Metric ftpGetNextRemoteObjectMetric = StatisticsManager.createMetric((String)"FTPGetNextRemoteObjectMetric", (String)"Time to get next file from FTP Location", (StatisticsManager.MetricType)StatisticsManager.MetricType.SOURCE);
    private FTPClient ftpClient = new FTPClient();
    private FTPListParseEngine engine;
    private String directory;
    private String server;
    private int port;
    private String username = "anonymous";
    private String password = "anonymous";
    private String tmpDownloadDir;
    private static final String extensionSeparator = ".";
    private boolean isClosed = false;

    public static void main(String[] args) throws Exception {
        Parameter srcdir = new Parameter(PARAMETER_DirectoryName, "videosource");
        Parameter trgdir = new Parameter(PARAMETER_DirectoryName, "sink");
        Parameter username = new Parameter(PARAMETER_Username, "dimitris");
        Parameter password = new Parameter(PARAMETER_Password, "...");
        Parameter[] inputParameters = new Parameter[]{srcdir, username, password};
        Parameter[] outputParameters = new Parameter[]{trgdir, username, password};
        FTPDataSource ftpDataSource = new FTPDataSource("dl07.di.uoa.gr", inputParameters);
        FTPDataSink ftpDataSink = new FTPDataSink("dl07.di.uoa.gr", outputParameters);
        while (ftpDataSource.hasNext()) {
            try {
                DataElement elm = ftpDataSource.next();
                if (elm == null) continue;
                System.out.println(elm.getContentType().getMimeType());
                System.out.println("Going to store: " + elm.getId());
                ftpDataSink.append(elm);
            }
            catch (Exception e) {
                log.error("Did not manage to append data element to the data sink", (Throwable)e);
            }
        }
        System.out.println("----- Statistics -----");
        System.out.println(StatisticsManager.toXML());
    }

    public FTPDataSource(String input, Parameter[] inputParameters) throws Exception {
        this.server = input;
        this.port = this.ftpClient.getDefaultPort();
        this.directory = "";
        if (inputParameters != null && inputParameters.length > 0) {
            for (Parameter param : inputParameters) {
                if (param.getName() == null || param.getName().trim().length() <= 0 || param.getValue() == null) continue;
                if (param.getName().equals(PARAMETER_DirectoryName)) {
                    this.directory = param.getValue();
                    if (this.directory.endsWith("/")) continue;
                    this.directory = this.directory + "/";
                    continue;
                }
                if (param.getName().equals(PARAMETER_Username)) {
                    this.username = param.getValue();
                    continue;
                }
                if (param.getName().equals(PARAMETER_Password)) {
                    this.password = param.getValue();
                    continue;
                }
                if (!param.getName().equals(PARAMETER_Port)) continue;
                this.port = Integer.parseInt(param.getValue());
            }
        }
        log.debug("Ininializing ftp data source at: " + this.username + "@" + this.server + ":" + this.port);
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
        log.info("Connected to " + this.server + extensionSeparator);
        log.info("FTP server replied: " + this.ftpClient.getReplyString());
        int replyCode = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            log.error("FTP server refused connection. Reply CODE: " + replyCode);
            this.ftpClient.disconnect();
            throw new Exception("FTP server refused connection. Reply CODE: " + replyCode);
        }
        this.engine = this.ftpClient.initiateListParsing(this.directory);
        this.tmpDownloadDir = TempFileManager.genarateTempSubDir();
        log.debug("Managed to create temporary directory to " + this.tmpDownloadDir);
    }

    public boolean hasNext() {
        return this.engine.hasNext();
    }

    public DataElement next() {
        long startTimeGN = System.currentTimeMillis();
        FTPFile[] files = this.engine.getNext(1);
        ftpGetNextRemoteObjectMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTimeGN));
        FTPFile file = files[0];
        int tries = 0;
        while (true) {
            try {
                if (!file.isDirectory()) {
                    String remoteFileName = this.directory + file.getName();
                    log.debug("Returning next data element: " + remoteFileName);
                    long startTime = System.currentTimeMillis();
                    String extention = FTPDataSource.getFileExtention(file.getName());
                    String localFileName = TempFileManager.generateTempFileName((String)this.tmpDownloadDir);
                    if (extention != null) {
                        localFileName = localFileName + extensionSeparator + extention;
                    }
                    File localFile = new File(localFileName);
                    FileOutputStream outStream = new FileOutputStream(localFile);
                    this.ftpClient.retrieveFile(remoteFileName, (OutputStream)outStream);
                    outStream.close();
                    ftpDownloadObjectMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTime));
                    LocalFileDataElement elm = new LocalFileDataElement();
                    elm.setAttribute("DocumentName", file.getName());
                    elm.setContent(localFile);
                    elm.setId(remoteFileName);
                    return elm;
                }
                return null;
            }
            catch (Exception e) {
                if (tries == 3) {
                    log.error("Did not manage to get next element...", (Throwable)e);
                    return null;
                }
                ++tries;
                log.error("Did not manage to get next element, reconnecting and trying again...", (Throwable)e);
                try {
                    log.debug("Trying to reconnect to the ftp");
                    this.reconnect();
                }
                catch (Exception e1) {
                    log.error("Could not reconnect to the server", (Throwable)e1);
                    return null;
                }
            }
        }
    }

    private void reconnect() throws Exception {
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
    }

    private static String getFileExtention(String fileName) {
        int dot = fileName.lastIndexOf(extensionSeparator);
        if (dot == -1) {
            return null;
        }
        return fileName.substring(dot + 1);
    }

    public void close() {
        this.isClosed = true;
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.disconnect();
            }
            catch (Exception e) {
                log.error("Did not manage to disconnect from data sink", (Throwable)e);
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public DataElement getDataElement(String dataElementID) throws Exception {
        long startTime = System.currentTimeMillis();
        String extention = FTPDataSource.getFileExtention(dataElementID);
        int tries = 0;
        while (true) {
            try {
                String localFileName = TempFileManager.generateTempFileName((String)this.tmpDownloadDir);
                if (extention != null) {
                    localFileName = localFileName + extensionSeparator + extention;
                }
                File localFile = new File(localFileName);
                FileOutputStream outStream = new FileOutputStream(localFile);
                this.ftpClient.retrieveFile(dataElementID, (OutputStream)outStream);
                outStream.close();
                ftpDownloadObjectMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTime));
                LocalFileDataElement elm = new LocalFileDataElement();
                elm.setContent(localFile);
                elm.setId(dataElementID);
                return elm;
            }
            catch (Exception e) {
                if (tries == 3) {
                    log.error("Did not manage to get next element...", (Throwable)e);
                    throw new Exception("Did not manage to get next element...", e);
                }
                ++tries;
                log.error("Did not manage to get next element, reconnecting and trying again...", (Throwable)e);
                try {
                    log.debug("Trying to reconnect to the ftp");
                    this.reconnect();
                }
                catch (Exception e1) {
                    log.error("Could not reconnect to the server", (Throwable)e1);
                    throw new Exception("Could not reconnect to the server", e1);
                }
            }
        }
    }

    public String getNextDataElementID() throws Exception {
        long startTimeGN = System.currentTimeMillis();
        FTPFile[] files = this.engine.getNext(1);
        ftpGetNextRemoteObjectMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTimeGN));
        FTPFile file = files[0];
        try {
            if (!file.isDirectory()) {
                String remoteFileName = this.directory + file.getName();
                log.debug("Returning next data element: " + remoteFileName);
                return remoteFileName;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Did not manage to get next element, returning null...");
            return null;
        }
    }

    public FTPDataSource() {
    }

    public void initializeDistributableDataSource(String input, Parameter[] inputParameters) throws Exception {
        this.server = input;
        this.username = "anonymous";
        this.password = "anonymous";
        this.port = this.ftpClient.getDefaultPort();
        this.directory = "";
        if (inputParameters != null && inputParameters.length > 0) {
            for (Parameter param : inputParameters) {
                if (param.getName() == null || param.getName().trim().length() <= 0 || param.getValue() == null) continue;
                if (param.getName().equals(PARAMETER_DirectoryName)) {
                    this.directory = param.getValue();
                    if (this.directory.endsWith("/")) continue;
                    this.directory = this.directory + "/";
                    continue;
                }
                if (param.getName().equals(PARAMETER_Username)) {
                    this.username = param.getValue();
                    continue;
                }
                if (param.getName().equals(PARAMETER_Password)) {
                    this.password = param.getValue();
                    continue;
                }
                if (!param.getName().equals(PARAMETER_Port)) continue;
                this.port = Integer.parseInt(param.getValue());
            }
        }
        log.debug("Ininializing ftp data source at: " + this.username + "@" + this.server + ":" + this.port);
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
        log.info("Connected to " + this.server + extensionSeparator);
        log.info("FTP server replied: " + this.ftpClient.getReplyString());
        int replyCode = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            log.error("FTP server refused connection. Reply CODE: " + replyCode);
            this.ftpClient.disconnect();
            throw new Exception("FTP server refused connection. Reply CODE: " + replyCode);
        }
        this.engine = this.ftpClient.initiateListParsing(this.directory);
        this.tmpDownloadDir = TempFileManager.genarateTempSubDir();
    }

    public ContentType nextContentType() {
        try {
            String builder = "ftp://" + this.server + "/" + this.getNextDataElementID();
            URLDataElement de = new URLDataElement(builder);
            return de == null ? null : de.getContentType();
        }
        catch (Exception e) {
            log.error("Did not manage to get next element's contentn type, returning null...");
            return null;
        }
    }
}

