/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.Record;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.utils.queue.MemoryFileBackedQueue;
import org.gcube.datatransformation.datatransformationlibrary.utils.stax.StaxReader;
import org.gcube.datatransformation.datatransformationlibrary.utils.stax.StaxResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPDataSource
implements DataSource,
ContentTypeDataSource {
    private static Logger log = LoggerFactory.getLogger(HTTPDataSource.class);
    private static final String COLLECTION = "collection";
    private static final String NAME = "name";
    private static final String PROVENANCE = "provenance";
    private static final String TIMESTAMP = "timestamp";
    private static final String RECORDS = "records";
    private static final String RECORD = "record";
    private static final String ID = "id";
    private static final String FIELDS = "fields";
    private static final String FIELD = "field";
    private static final String MIMETYPE = "mimetype";
    private static final String PAYLOAD = "payload";
    private static final String COLLNAMEPATH = "/collection/name";
    private static final String COLLPROVENANCEPATH = "/collection/provenance";
    private static final String COLLTIMESTAMPPATH = "/collection/timestamp";
    private static final String RECORDIDPATH = "/collection/records/record/id";
    private static final String FIELDNAMEPATH = "/collection/records/record/fields/field/name";
    private static final String FIELDMIMETYPEPATH = "/collection/records/record/fields/field/mimetype";
    private static final String FIELDPAYLOADPATH = "/collection/records/record/fields/field/payload";
    private Map<String, String> pathsMap;
    private DataBridge bridge = DTSCore.getDataBridge();
    private URL url;
    private String collectionID;
    private String provenance;
    private String timestamp;
    private volatile boolean finished = false;
    private Object sync = new Object();
    private Object waitInit = new Object();
    private MemoryFileBackedQueue<Record> queue;
    private StaxReader staxReader;

    private void init() {
        this.pathsMap = new HashMap<String, String>();
        this.pathsMap.put(CollPaths.COLLNAMEPATH.toString(), COLLNAMEPATH);
        this.pathsMap.put(CollPaths.COLLPROVENANCEPATH.toString(), COLLPROVENANCEPATH);
        this.pathsMap.put(CollPaths.COLLTIMESTAMPPATH.toString(), COLLTIMESTAMPPATH);
        this.pathsMap.put(CollPaths.RECORDIDPATH.toString(), RECORDIDPATH);
        this.pathsMap.put(CollPaths.FIELDNAMEPATH.toString(), FIELDNAMEPATH);
        this.pathsMap.put(CollPaths.FIELDMIMETYPEPATH.toString(), FIELDMIMETYPEPATH);
        this.pathsMap.put(CollPaths.FIELDPAYLOADPATH.toString(), FIELDPAYLOADPATH);
    }

    public HTTPDataSource(String input, Parameter[] inputParameters) throws XMLStreamException, IOException {
        this.url = new URL(input);
        log.debug("Going to fetch objects from url location: " + this.url);
        this.init();
        if (inputParameters != null) {
            for (Parameter par : inputParameters) {
                if (!this.pathsMap.containsKey(par.getName())) continue;
                this.pathsMap.put(par.getName(), par.getValue());
            }
        }
        this.staxReader = new StaxReader(new HashSet<String>(this.pathsMap.values()), this.url);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    this.setName("HTTPDataSourceRetriever");
                    try {
                        HTTPDataSource.this.queue = new MemoryFileBackedQueue(100);
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                log.info("File backed queue created for storing input");
                                int i = 0;
                                Record rec = new Record();
                                while (HTTPDataSource.this.staxReader.hasNext()) {
                                    Object object;
                                    Object object2;
                                    StaxResponse resp = HTTPDataSource.this.staxReader.next();
                                    if (resp == null) continue;
                                    if (resp.getPath().equals(HTTPDataSource.this.pathsMap.get(CollPaths.COLLNAMEPATH.toString()))) {
                                        object2 = HTTPDataSource.this.waitInit;
                                        synchronized (object2) {
                                            HTTPDataSource.this.collectionID = resp.getResult();
                                            HTTPDataSource.this.waitInit.notify();
                                            object = HTTPDataSource.this.sync;
                                            synchronized (object) {
                                                HTTPDataSource.this.sync.notify();
                                            }
                                        }
                                    }
                                    if (resp.getPath().equals(HTTPDataSource.this.pathsMap.get(CollPaths.COLLPROVENANCEPATH.toString()))) {
                                        object2 = HTTPDataSource.this.waitInit;
                                        synchronized (object2) {
                                            HTTPDataSource.this.provenance = resp.getResult();
                                            HTTPDataSource.this.waitInit.notify();
                                            object = HTTPDataSource.this.sync;
                                            synchronized (object) {
                                                HTTPDataSource.this.sync.notify();
                                            }
                                        }
                                    }
                                    if (resp.getPath().equals(HTTPDataSource.this.pathsMap.get(CollPaths.COLLTIMESTAMPPATH.toString()))) {
                                        object2 = HTTPDataSource.this.waitInit;
                                        synchronized (object2) {
                                            HTTPDataSource.this.timestamp = resp.getResult();
                                            HTTPDataSource.this.waitInit.notify();
                                            object = HTTPDataSource.this.sync;
                                            synchronized (object) {
                                                HTTPDataSource.this.sync.notify();
                                            }
                                        }
                                    }
                                    if (resp.getPath().equals(HTTPDataSource.this.pathsMap.get(CollPaths.RECORDIDPATH.toString()))) {
                                        rec.id = resp.getResult();
                                        if (!rec.isInitialised()) {
                                            continue;
                                        }
                                    } else if (resp.getPath().equals(HTTPDataSource.this.pathsMap.get(CollPaths.FIELDMIMETYPEPATH.toString()))) {
                                        rec.mimetype = resp.getResult();
                                        if (!rec.isInitialised()) {
                                            continue;
                                        }
                                    } else if (resp.getPath().equals(HTTPDataSource.this.pathsMap.get(CollPaths.FIELDPAYLOADPATH.toString()))) {
                                        rec.payload = resp.getResult();
                                        if (!rec.isInitialised()) {
                                            continue;
                                        }
                                    } else {
                                        log.warn("Unrecognized field under path " + resp.getPath());
                                        continue;
                                    }
                                    if (++i % 100 == 0) {
                                        log.debug("fetched " + i + " records.");
                                    }
                                    log.trace("record #" + i + " retrived");
                                    HTTPDataSource.this.queue.offer(rec);
                                    rec = new Record();
                                    object2 = HTTPDataSource.this.sync;
                                    synchronized (object2) {
                                        HTTPDataSource.this.sync.notify();
                                    }
                                }
                                Object object = HTTPDataSource.this.sync;
                                synchronized (object) {
                                    HTTPDataSource.this.finished = true;
                                    HTTPDataSource.this.sync.notify();
                                }
                            }
                        }.start();
                        Object object = HTTPDataSource.this.waitInit;
                        synchronized (object) {
                            while (HTTPDataSource.this.collectionID == null || HTTPDataSource.this.provenance == null || HTTPDataSource.this.timestamp == null) {
                                HTTPDataSource.this.waitInit.wait();
                            }
                        }
                        while (!(HTTPDataSource.this.finished && HTTPDataSource.this.queue.size() <= 0 || HTTPDataSource.this.bridge.isClosed())) {
                            Object object2 = HTTPDataSource.this.sync;
                            synchronized (object2) {
                                while (HTTPDataSource.this.queue.size() == 0) {
                                    HTTPDataSource.this.sync.wait();
                                    if (!HTTPDataSource.this.finished) continue;
                                    break block15;
                                }
                            }
                            Record rec = (Record)HTTPDataSource.this.queue.poll();
                            if (rec == null) {
                                log.warn("Queue returned null");
                                continue;
                            }
                            HTTPDataSource.this.manageObject(rec.id, rec.mimetype, rec.payload);
                        }
                    }
                    catch (Exception e) {
                        log.error("Did not manage to fetch content from cms", (Throwable)e);
                    }
                    finally {
                        log.info("Removing queue.");
                        HTTPDataSource.this.queue.destroy();
                        HTTPDataSource.this.bridge.close();
                    }
                }
            }
        }.start();
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = this.bridge.next();
        return de == null ? null : de.getContentType();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() {
        return this.bridge.next();
    }

    private void manageObject(String id, String mimetype, String payload) {
        try {
            StrDataElement object = StrDataElement.getSourceDataElement();
            object.setId(id);
            object.setContent(payload);
            object.setAttribute("CollectionID", this.collectionID);
            object.setAttribute("ContentOID", id);
            object.setContentType(new ContentType(mimetype, new ArrayList()));
            this.bridge.append((DataElement)object);
            log.trace("Object with id " + id + " was added for processing by HTTP source");
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " was added for processing"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + id, (Throwable)e);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " could not be fetched"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
        }
    }

    public static void main(String[] args) throws XMLStreamException, IOException {
        HTTPDataSource ds = new HTTPDataSource("http://localhost/test.xml", null);
        while (ds.hasNext()) {
            StrDataElement de = (StrDataElement)ds.next();
            System.out.println(de.getId());
            System.out.println(de.getContentType().getMimeType());
            System.out.println(de.getStringContent());
            System.out.println(de.getAllAttributes());
            System.out.println("-------------------------------------------");
        }
    }

    static enum CollPaths {
        COLLNAMEPATH,
        COLLPROVENANCEPATH,
        COLLTIMESTAMPPATH,
        RECORDIDPATH,
        FIELDNAMEPATH,
        FIELDMIMETYPEPATH,
        FIELDPAYLOADPATH;

    }
}

